// Add Plexible UI class to admin wrapper
document.addEventListener('DOMContentLoaded', () => {
  const wrapper = document.querySelector('.wp-admin');
  if (wrapper) {
    wrapper.classList.add('plexible-ui');
  }

  // Handle all remove buttons dynamically
  document.addEventListener('click', function (e) {
    if (!e.target.classList.contains('icon-remove-btn')) return;

    const btn = e.target;
    const field = btn.closest('.acf-field');
    if (!field) return;

    field.querySelectorAll('input.acf-icon-picker-dashicon-radio').forEach((radio) => (radio.checked = false));

    field.querySelectorAll('.acf-icon-picker-dashicon.active').forEach((icon) => icon.classList.remove('active'));

    const hiddenInput = field.querySelector('input[type="hidden"]');
    if (hiddenInput) hiddenInput.value = '';

    if (hiddenInput) hiddenInput.dispatchEvent(new Event('change', { bubbles: true }));

  });
// Handle showing/hiding button based on active tab
  function toggleRemoveButton(field) {
    const removeBtn = field.querySelector('.icon-remove-btn');
    if (!removeBtn) return;

    // Find the active <li> in the tabs
    const activeTabLi = field.querySelector('.acf-icon-picker li.active');
    if (!activeTabLi) {
      removeBtn.style.display = 'none';
      return;
    }

    const activeTabKey = activeTabLi.querySelector('a')?.dataset.uniqueTabKey;

    if (activeTabKey === 'dashicons') {
      removeBtn.style.display = 'inline-block';
    } else {
      removeBtn.style.display = 'none';
    }
  }

// Initialize all icon picker fields
  document.querySelectorAll('.acf-field[data-name="icon_lib"]').forEach(field => {
    toggleRemoveButton(field);

    // Listen for tab clicks
    const tabsLinks = field.querySelectorAll('.acf-icon-picker li a');
    tabsLinks.forEach(tabLink => {
      tabLink.addEventListener('click', () => {
        // Wait a tiny bit for the active class to switch
        setTimeout(() => toggleRemoveButton(field), 10);
      });
    });
  });

});

