<?php

/**
 * Component: PLX 2 - Dynamic 1
 * Variant: Grid
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);

// TODO: refactor below
$args = $args ?? [];
[
  'type' => $type,
  'custom' => [
    'card_text' => $custom_card_text,
    'card_background' => $custom_card_background,
    'card_border' => $custom_card_border,
  ],
] = $args;

$card_styles = [
  '--card-text' => $custom_card_text,
  '--card-background' => $custom_card_background,
  '--card-border-color' => $custom_card_border,
];
$card_styles = array_filter($card_styles, fn($value) => !empty($value));
$card_css_declarations = array_map(
  fn($value, $prop) => sprintf('%s: %s', $prop, esc_attr($value)),
  $card_styles,
  array_keys($card_styles)
);
$card_inline_styles = $card_css_declarations ? 'style="' . implode('; ', $card_css_declarations) . '"' : '';
?>

<div class="wrapper">
    <div class="layout_row">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

        <?php if ($posts_query->have_posts()): ?>
          <div class="dynamic-one-layout_grid">
            <?php while ($posts_query->have_posts()): ?>
              <?php
              $posts_query->the_post();
              $legacy_icon = get_field('icon_lib');
              $legacy_excerpt = get_field('excerpt');
              $legacy_child_label = get_field('cta');
              $preview = get_field('preview') ?: [];
              $has_child = get_field('has_child');
              $icon = !empty($preview['icon_lib']) ? $preview['icon_lib'] : $legacy_icon;
              $image = !empty($preview['image']) ? $preview['image'] : $legacy_icon;
              $excerpt = !empty($preview['excerpt']) ? $preview['excerpt'] : $legacy_excerpt;
              $child_label = !empty($preview['cta']) ? $preview['cta'] : $legacy_child_label;
              ?>
              <?php component('card', [
                'icon' => [
                  'provider' => 'acf',
                  'src' => $icon,
                  'has_background' => false,
                ],
                'image' => $preview['image'],
                'heading' => get_the_title(),
                'description' => $excerpt,
                'href' => $has_child ? esc_url(get_the_permalink()) : '',
                'has_border' => true,
                'cta' => $child_label,
                'align' => $props['align'],
              ]); ?>
            <?php endwhile; ?>
          </div>
        <?php else: ?>
          <?php component('error-boundary', [
            'title' => 'No Posts Found',
            'details' => 'Add posts, or remove this block.',
          ]); ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>

    </div>
</div>
