<?php

/**
 * Component: PLX 2 - Dynamic 1
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="wrapper">
    <div class="layout_row">
      <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

      <?php if ($posts_query->have_posts()): ?>
        <div class="layout_row" data-gap="small">

          <div class="swiper" data-js-target="swiper.c2Slider">
            <div class="swiper-wrapper">
              <?php while ($posts_query->have_posts()): ?>
                <?php $posts_query->the_post(); ?>
                <?php
                $legacy_icon = get_field('icon_lib');
                $legacy_excerpt = get_field('excerpt');
                $legacy_child_label = get_field('cta');
                $preview = get_field('preview') ?: [];
                $has_child = get_field('has_child');
                $icon = !empty($preview['icon_lib']) ? $preview['icon_lib'] : $legacy_icon;
                $excerpt = !empty($preview['excerpt']) ? $preview['excerpt'] : $legacy_excerpt;
                $child_label = !empty($preview['cta']) ? $preview['cta'] : $legacy_child_label;
                ?>
                <div class="swiper-slide">
                  <?php component('card', [
                    'icon' => [
                      'provider' => 'acf',
                      'src' => $icon,
                      'has_background' => false,
                    ],
                    'heading' => get_the_title(),
                    'description' => $excerpt,
                    'href' => $has_child ? esc_url(get_the_permalink()) : '',
                    'has_border' => true,
                    'cta' => $child_label,
                    'align' => $props['align'],
                  ]); ?>
                </div>
              <?php endwhile; ?>
            </div>
          </div>

          <div class="controls variant--center" data-js-target="swiper.c2SliderControls">
            <div class="swiper-navigation">
              <button class="icon-button variant--secondary --prev">
                <span class="sr-only">Previous</span>
                <?= get_icon('chevron-left') ?>
              </button>
              <button class="icon-button variant--secondary --next">
                <span class="sr-only">Next</span>
                <?= get_icon('chevron-right') ?>
              </button>
            </div>
          </div>

        </div>
      <?php else: ?>
        <?php component('error-boundary', [
          'title' => 'No Posts Found',
          'details' => 'Add posts, or remove this block.',
        ]); ?>
      <?php endif; ?>
      <?php wp_reset_postdata(); ?>
    </div>
</div>
