<?php

/**
 * Component: PLX 4 - Dynamic 3
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'type' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="wrapper">
    <div class="layout_row">

        <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

        <?php if ($posts_query->have_posts()): ?>
          <div class="layout_row" data-gap="small">
            <div class="swiper" data-js-target="swiper.c4Slider">
              <div class="swiper-wrapper">
                <?php while ($posts_query->have_posts()): ?>
                  <?php
                  $posts_query->the_post();
                  $legacy_description = get_field('description');
                  $legacy_child_label = get_field('cta');
                  $legacy_figure = get_field('image');
                  $preview = get_field('preview') ?: [];
                  $has_child = get_field('has_child');
                  $description = !empty($preview['description']) ? $preview['description'] : $legacy_description;
                  $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;
                  $child_label = !empty($preview['cta']) ? $preview['cta'] : $legacy_child_label;
                  ?>
                  <div class="swiper-slide">
                    <div class="layout_column" data-align="center">
                      <div class="column">
                        <div class="content">
                          <?php component('copy', [
                            'has_title' => true,
                            'title' => get_the_title(),
                            'has_body' => !empty($description),
                            'body' => $description,
                            'has_footer' => $has_child,
                            'button_group' => [
                              [
                                'variant' => '4',
                                'link' => [
                                  'title' => $child_label,
                                  'url' => get_the_permalink(),
                                ],
                              ],
                            ],
                          ]); ?>
                        </div>
                      </div>
                      <div class="column">
                        <div class="canvas">
                          <?php if (!empty($figure['provider'])): ?>
                            <?php component('figure', [
                              'src' => $figure,
                              'type' => 'fill',
                              'shape' => 'rounded',
                              'has_shadow' => true,
                            ]); ?>
                          <?php elseif (!empty($figure)): ?>
                            <div class="figure w-full h-full">
                              <img src="<?= esc_url($figure) ?>" alt="">
                            </div>
                          <?php else: ?>
                            <span class="figure-placeholder" data-label="Upload Image"></span>
                          <?php endif; ?>
                        </div>
                      </div>

                    </div>
                  </div>
                <?php endwhile; ?>
              </div>
            </div>

            <div class="layout_column">
                <div class="column" data-show="tablet"></div>

                <div class="column">
                  <div class="controls variant--space-between"
                    data-js-target="swiper.c4SliderControls">
                    <div class="swiper-navigation">
                      <button class="icon-button variant--secondary --prev">
                        <span class="sr-only">Previous</span>
                        <?= get_icon('chevron-left') ?>
                      </button>
                      <button class="icon-button variant--secondary --next">
                        <span class="sr-only">Next</span>
                        <?= get_icon('chevron-right') ?>
                      </button>
                    </div>
                    <div class="swiper-progress">
                      <div class="swiper-progress-index-first"></div>
                      <div class="swiper-progress-bar"></div>
                      <div class="swiper-progress-index-last"></div>
                    </div>
                  </div>
                </div>
            </div>
          </div>
        <?php else: ?>
          <?php component('error-boundary', [
            'title' => 'No Posts Found',
            'details' => 'Add posts, or remove this block.',
          ]); ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>

    </div>
</div>
