<?php

/**
 * Component: PLX 05 - Logo list
 * Variant: Card
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'gallery' => [],
  'align' => null,
  'type' => null,
];

$props = array_merge_deep($_query, $args ?? []);

$gallery = $props['gallery'];
?>

<div class="wrapper">
  <div class="layout_row">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <div class="<?= cn('layout_flex_grid', 'logo-list', $props['type']) ?>">
      <?php foreach ($gallery as $image): ?>
        <?php $link = get_field('media_custom_url', $image['ID']); ?>
        <div class="logo-list-item" role="listitem">
          <?php if (!empty($link)): ?>
            <a
              href="<?= $link['url'] ?>"
              target="<?= esc_attr($link['target'] ? $link['target'] : '_self') ?>"
              class="logo-card"
            >
              <div class="logo-card-content">
                <img
                  src="<?= esc_url($image['url']) ?>"
                  alt="<?= esc_attr($image['alt']) ?>"
                />
                <?php if (!empty($image['description'])): ?>
                  <span class="description"><?= $image['description'] ?></span>
                <?php endif; ?>
              </div>
            </a>
          <?php else: ?>
            <div class="logo-card">
              <div class="logo-card-content">
                <img
                  src="<?= esc_url($image['url']) ?>"
                  alt="<?= esc_attr($image['alt']) ?>"
                />
                <?php if (!empty($image['description'])): ?>
                  <span><?= $image['description'] ?></span>
                <?php endif; ?>
              </div>
            </div>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
