<?php

/**
 * Component: PLX 05 - Logo list
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'gallery' => [],
  'align' => '',
  'type' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$gallery = $props['gallery'];
?>

<div class="layout-block">
  <div class="layout-row">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <div class="<?= cn('logo-list', $props['type']) ?>">
      <?php foreach ($gallery as $image): ?>
        <?php $link = get_field('media_custom_url', $image['ID']); ?>
        <div class="logo-list-item">
          <?php if (!empty($link)): ?>
            <a
              href="<?= $link['url'] ?>"
              target="<?= esc_attr($link['target'] ?: '_self') ?>"
            >
              <img
                src="<?= esc_url($image['url']) ?>"
                alt="<?= esc_attr($image['alt']) ?>"
              />
            </a>
          <?php else: ?>
            <img
              src="<?= esc_url($image['url']) ?>"
              alt="<?= esc_attr($image['alt']) ?>"
            />
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
