<?php

/**
 * Component: PLX 06 - Contact Form
 * Variant: Contact
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'form' => [
    'id' => '',
  ],
  'contact' => [
    'email_label' => '',
    'email' => '',
    'phone_label' => '',
    'phone' => '',
    'address_label' => '',
    'address' => '',
    'icon_styles' => '',
    'icon_classes' => '',
  ],
  'align' => '',
  'type' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$form = $props['form'];
$contact = $props['contact'];
?>

<div class="wrapper">
  <div class="layout_column" data-columns="1,3">
    <div class="column">
      <div class="card">
        <?php component('copy', [...$props['content'], 'type' => 'variant--subsection']); ?>
        <?php if (!empty($form['id'])): ?>
          <?php component('form', ['data' => ['provider' => 'formidable', 'id' => $form['id']]]); ?>
        <?php endif; ?>
      </div>
    </div>

    <div class="column" data-theme="dark">
      <div
        class="<?= cn('list', $contact['icon_classes']) ?>"
        <?= $contact['icon_styles'] ?>
      >
        <ul class="list--list">
          <?php if (!empty($contact['phone'])): ?>
            <?php
            $numeric = str_replace('-', '', $contact['phone']);
            $formatted = preg_match('/^(\d{3})-(\d{3})-(\d{4})$/', $contact['phone'], $matches)
              ? sprintf('(%s) %s-%s', $matches[1], $matches[2], $matches[3])
              : $contact['pnone'];
            ?>
            <li class="list--item">
              <div class="icon">
                <div class="icon-inner">
                  <span class="dashicons dashicons-phone"></span>
                </div>
              </div>
              <span class="list--title"><?= $contact['phone_label'] ?></span>
              <a href="tel:<?= htmlspecialchars($numeric) ?>" class="link">
                <?= htmlspecialchars($formatted) ?>
              </a>
            </li>
          <?php endif; ?>

          <?php if (!empty($contact['email'])): ?>
            <li class="list--item">
              <div class="icon">
                <div class="icon-inner">
                  <span class="dashicons dashicons-email"></span>
                </div>
              </div>
              <span class="list--title"><?= $contact['email_label'] ?></span>
              <a href="mailto:<?= $contact['email'] ?>" class="link"><?= $contact['email'] ?></a>
            </li>
          <?php endif; ?>

          <?php if (!empty($contact['address'])): ?>
            <li class="list--item">
              <div class="icon">
                <div class="icon-inner">
                  <span class="dashicons dashicons-location"></span>
                </div>
              </div>
              <span class="list--title"><?= $contact['address_label'] ?></span>
              <p><?= $contact['address'] ?></p>
            </li>
          <?php endif; ?>
        </ul>
      </div>
    </div>

  </div>
</div>
