<?php

/**
 * Component: PLX 7 - Text Grid
 * Variant: Default
 */

$passed_args = $args ?? [];

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'items' => [],
  'align' => '',
  'column_breakpoint' => '',
];

$props = array_merge_deep($_query, $passed_args);

$items = $props['items'];
?>

<div class="wrapper">
  <div class="layout_row">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <?php if (!empty($items)): ?>
      <div class="<?= cn('text-item_grid') ?>" style="<?= $props['column_breakpoint'] ?>">
        <?php foreach ($items as $item): ?>
          <?php component('copy', [
            'type' => 'variant--detail',
            'align' => $props['align'],
            'has_icon' => $item['item_has_icon'],
            'icon' => [
              'provider' => 'acf',
              'src' => $item['item_icon'],
            ],
            'has_caption' => !empty($item['item_title']),
            'caption' => $item['item_title'],
            'has_body' => !empty($item['item_body']),
            'body' => $item['item_body'],
          ]); ?>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
