<?php

/**
 * Component: PLX 8 - Map
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'items' => [],
  'map' => [
    'location' => '',
  ],
  'type' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$content = $props['content'];
$items = $props['items'];
$map = $props['map'];

$title_copy_data = array_intersect_key($content, array_flip(['has_caption', 'caption', 'has_title', 'title']));
$body_copy_data = array_intersect_key($content, array_flip(['has_body', 'body', 'has_footer', 'button_group']));
?>
<div class="wrapper">
  <div class="layout_row">

    <div class="layout_column">
      <div class="column">
        <?php component('copy', [...$title_copy_data, 'type' => 'variant--section']); ?>
      </div>
      <div class="column">
        <?php component('copy', [...$body_copy_data, 'type' => 'variant--section']); ?>
      </div>
    </div>

    <div class="layout_column">
      <?php if (!empty($items)): ?>
        <div class="column">
          <div class="list">
            <ul class="list--list">
              <?php foreach ($items as $item): ?>
                <?php
                $item_title = get_sub_field('item_title');
                $item_body = get_sub_field('item_body');
                ?>
                <li class="list--item">
                  <?php component('copy', [
                    'type' => 'variant--detail',
                    'has_caption' => !empty($item['item_title']),
                    'caption' => $item['item_title'],
                    'has_body' => !empty($item['item_body']),
                    'body' => $item['item_body'],
                  ]); ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      <?php endif; ?>

      <?php if (!empty($map['location'])): ?>
        <div class="column">
          <div class="map">
            <?php if ($map['location']): ?>
              <div class="acf-map" data-zoom="16" data-theme="light">
                <div
                  class="marker"
                  data-lat="<?= esc_attr($map['location']['lat']) ?>"
                  data-lng="<?= esc_attr($map['location']['lng']) ?>">
                </div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>
    </div>

  </div>
</div>

