<?php

/**
 * Component: PLX 09 - Text / Image
 * Variant: Default
 */

$passed_args = $args ?? [];

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'items' => [],
  'image' => [],
  'figure' => [],
  'align' => '',
  'item_align' => '',
  'item_reverse' => false,
  'type' => '',
];

$props = array_merge_deep($_query, $passed_args);

$items = $props['items'];
$figure_legacy = $props['image'];
$figure = $props['figure'];
?>

<div class="wrapper">
  <div class="layout_row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <div
      class="<?= cn('text-image_layout', $props['item_align'], $props['item_reverse']) ?>"
    >
      <?php if (!empty($items)): ?>
        <div class="content">
          <div class="list">
            <ul class="list--list">
              <?php foreach ($items as $item): ?>
                <li class="list--item">
                  <?php component('copy', [
                    'has_title' => $item['has_title'],
                    'title' => $item['title'],
                    'has_body' => $item['has_body'],
                    'body' => $item['body'],
                    'has_footer' => $item['has_footer'],
                    'button_group' => $item['button_group'],
                  ]); ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      <?php endif; ?>

      <div class="visual">
        <?php if (!empty($figure['provider'])): ?>
          <?php component('figure', [
            'src' => $figure,
            'type' => 'fill',
            'shape' => 'rounded',
            'has_shadow' => true,
          ]); ?>
        <?php elseif (!empty($figure)): ?>
          <div class="figure has-shadow" data-variant="fill" data-shape="rounded">
            <div class="figure_inner">
              <img src="<?= esc_url($figure['url']) ?>">
            </div>
          </div>
        <?php else: ?>
          <span class="figure-placeholder" data-label="Upload Image"></span>
        <?php endif; ?>
      </div>
    </div>

  </div>
</div>
