<?php

/**
 * Component: PLX 11 - Timeline
 * Variant: Default
 */

$args = $args ?? [];
[
  'content' => [
    'has_caption' => $has_caption,
    'caption' => $caption,
    'has_title' => $has_title,
    'title' => $title,
    'has_body' => $has_body,
    'body' => $body,
  ],
] = $args;
?>

<div class="layout-block">
    <div class="layout-row">

        <div class="copy variant--section">
            <?php if ($has_caption || $has_title): ?>
                <div class="copy--header">
                    <?php if ($has_caption): ?>
                        <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                        <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if ($has_body): ?>
                <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                </div>
            <?php endif; ?>
        </div>

        <?php if (have_rows('item')): ?>
            <div class="c11-menu">
                <nav>
                    <?php while (have_rows('item')):

                      the_row();
                      $year = get_sub_field('year');
                      ?>
                        <?php if ($year): ?>
                        <a href="#year-<?= $year ?>" class="link"><?= $year ?></a>
                    <?php endif; ?>
                    <?php
                    endwhile; ?>
                </nav>
            </div>

            <div class="c11-timeline">
                <?php while (have_rows('item')):

                  the_row();
                  $year = get_sub_field('year');
                  ?>
                    <article class="c11-timeline-item" data-year="<?= $year ?>">
                        <div class="c11-timeline-item_header">
                            <?php if ($year): ?>
                                <h3><?= $year ?></h3>
                            <?php endif; ?>
                        </div>
                        <ul class="c11-timeline-item_content">
                            <?php if (have_rows('event')): ?>
                                <?php while (have_rows('event')):

                                  the_row();
                                  $event_title = get_sub_field('event_title');
                                  $event_description = get_sub_field('event_description');
                                  $event_image = get_sub_field('event_image');
                                  ?>
                                    <li>
                                        <div class="copy variant--timeline">
                                            <?php if ($event_title): ?>
                                                <div class="copy--header">
                                                    <h3 class="copy--caption"><?= $event_title ?></h3>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($event_description || $event_image): ?>
                                                <div class="copy--body">
                                                    <?php if (!empty($event_image)): ?>
                                                        <div class="figure">
                                                            <img
                                                                    src="<?= esc_url($event_image['url']) ?>"
                                                                    alt="<?= esc_attr($event_image['alt']) ?>"
                                                            />
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="wysiwyg">
                                                        <?= $event_description ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                <?php
                                endwhile; ?>
                            <?php endif; ?>
                        </ul>
                    </article>
                <?php
                endwhile; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

