<?php

/**
 * Component: PLX 13 - Testimonials
 * Variant: Slider
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'type' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="wrapper">
  <div class="layout_row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <?php if ($posts_query->have_posts()): ?>
      <div class="testimonial_layout">
        <div class="testimonial_slides">
          <div class="swiper" data-js-target="swiper.testimonial.varSlider">
            <div class="swiper-wrapper items-center">
              <?php while ($posts_query->have_posts()): ?>
                <?php
                $posts_query->the_post();
                $quote = get_field('testimonial_quote');
                $name = get_field('testimonial_name');
                $position = get_field('testimonial_position');
                ?>
                <div class="swiper-slide">
                  <?php component('quote', [
                    'type' => 'feat',
                    'align' => 'center',
                    'content' => $quote,
                    'attribution' => [
                      'name' => $name,
                      'position' => $position,
                    ],
                  ]); ?>
                </div>
              <?php endwhile; ?>
            </div>
          </div>
        </div>

        <div class="testimonial_controls">
          <div class="controls variant--space-between" data-js-target="swiper.testimonial.varSliderControls">
            <button class="icon-button variant--secondary --prev">
              <span class="sr-only">Previous</span>
              <?= get_icon('chevron-left') ?>
            </button>
            <button class="icon-button variant--secondary --next">
              <span class="sr-only">Next</span>
              <?= get_icon('chevron-right') ?>
            </button>
          </div>
        </div>
      </div>
    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
