<?php

/**
 * Component: PLX 13 - Testimonials
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'type' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="layout-block">
  <div class="layout-row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <?php if ($posts_query->have_posts()): ?>
      <div class="testimonial_layout">
        <?php while ($posts_query->have_posts()): ?>
          <?php
          $posts_query->the_post();
          $quote = get_field('testimonial_quote');
          $name = get_field('testimonial_name');
          $position = get_field('testimonial_position');
          ?>
          <?php component('quote', [
            'content' => $quote,
            'attribution' => [
              'name' => $name,
              'position' => $position,
            ],
          ]); ?>
        <?php endwhile; ?>
      </div>
    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
