<?php

/**
 * Component: PLX 16 - Checklist
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'list' => [],
  'type' => '',
  'align' => '',
  'custom' => [
    'list_size' => '',
  ],
];

$props = array_merge_deep($_query, $args ?? []);

$list = $props['list'];
?>

<div class="wrapper">
  <div class="layout_row">
    <div class="layout_column" data-align="center">
      <div class="column">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>
      </div>
      <div class="column">
        <?php if (!empty($list)): ?>
          <div
            class="list"
            <?= attr_if('data-size', $props['custom']['list_size']) ?>
          >
            <ul class="list--list">
              <?php foreach ($list as $item): ?>
                <li class="list--item">
                  <span class="list--icon">
                    <?= get_icon('check') ?>
                  </span>
                  <span><?= $item['list_item'] ?></span>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>





