<?php

/**
 * Component: PLX 18 - Concierge
 * Variant: Default
 *
 * TODO: Refactor blocks, assign values per selection
 */

$args = $args ?? [];
[
  'content' => [
    'has_caption' => $has_caption,
    'caption' => $caption,
    'has_title' => $has_title,
    'title' => $title,
    'has_body' => $has_body,
    'body' => $body,
    'has_footer' => $has_footer,
    'button_group' => $button_group,
  ],
  'multi_mode' => $multi_mode,
  'has_form_title' => $has_form_title,
  'form_title' => $form_title,
  'form_id' => $form_id,
  'align' => $align,
] = $args;
?>

<div class="layout-block">
    <div class="layout-row">

        <div class="<?= cn('copy variant--section', $align) ?>">
            <?php if ($has_caption || $has_title): ?>
                <div class="copy--header">
                    <?php if ($has_caption): ?>
                        <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                        <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if ($has_body): ?>
                <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                </div>
            <?php endif; ?>
            <?php if ($has_footer): ?>
                <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                        <div class="button-group">
                            <?php foreach ($button_group as $i => $button): ?>
                                <?php $button_variant = match ($button['variant'] ?? null) {
                                  '0' => 'variant--primary',
                                  '1' => 'variant--secondary',
                                  '2' => 'variant--ghost',
                                  '3' => 'variant--white',
                                  '4' => 'variant--link',
                                  default => null,
                                }; ?>
                                <?php if ($button['link']): ?>
                                    <a
                                            class="<?= cn('button', $button_variant) ?>"
                                            href="<?= esc_url($button['link']['url']) ?>"
                                            target="<?= $button['link']['target'] ?>"
                                    >
                                        <?= $button['link']['title'] ?>
                                    </a>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="concierge" role="form" data-js-controller="concierge" <?= $multi_mode === 'true'
          ? 'data-js-allow-multiple-choices'
          : null ?>>

            <div class="steps" data-active="true">
                <?php if (have_rows('steps')):
                  $step_count = 0;
                  while (have_rows('steps')):

                    the_row();
                    $step_count++;
                    $step_title = get_sub_field('step_title');
                    $step_id = 'step-' . $step_count;
                    ?>
                        <div
                                class="step"
                                data-step="<?= $step_count ?>"
                            <?= $step_count === 1 ? 'data-active="true"' : '' ?>>
                            <div class="layout-row" data-gap="md">
                                <div class="copy">
                                    <div class="copy--header">
                                        <h3 id="<?= $step_id ?>"
                                            class="copy--title"><?= $step_title ?></h3>
                                    </div>
                                </div>
                                <?php if (have_rows('step_choices')): ?>
                                    <ul class="choices" role="group" aria-labelledby="<?= $step_id ?>">
                                        <?php while (have_rows('step_choices')):

                                          the_row();
                                          $choice_icon = get_sub_field('step_choice_icon');
                                          $choice_title = get_sub_field('step_choice_title');
                                          $choice_subtitle = get_sub_field('step_choice_subtitle');
                                          $choice_has_more_info = get_sub_field('step_choice_has_more_info');
                                          $choice_more_info = get_sub_field('step_choice_more_info');
                                          $choice_id = 'choice-' . $step_count . '-' . get_row_index();
                                          ?>
                                            <li class="choice">
                                                <div class="card concierge-card">
                                                    <span class="radio-indicator"></span>
                                                    <input type="checkbox" id="<?= $choice_id ?>"
                                                           name="step-<?= $step_count ?>"
                                                           class="sr-only">
                                                    <label for="<?= $choice_id ?>">
                                                        <div class="copy variant--subsection align--center">
                                                            <div class="copy--header">
                                                                <?php if ($choice_icon): ?>
                                                                    <div class="copy--caption">
                                                                        <?php if (
                                                                          'dashicons' === $choice_icon['type']
                                                                        ): ?>
                                                                            <div class="dashicons <?= esc_attr(
                                                                              $choice_icon['value']
                                                                            ) ?>"></div>
                                                                        <?php endif; ?>

                                                                        <?php if (
                                                                          'media_library' === $choice_icon['type']
                                                                        ):
                                                                          $attachment_id = array_unique(
                                                                            $choice_icon['value']
                                                                          ); ?>
                                                                            <div class="icon">
                                                                                <?= wp_get_attachment_image(
                                                                                  reset($icon['value']),
                                                                                  [64, 64]
                                                                                ) ?>
                                                                            </div>
                                                                        <?php
                                                                        endif; ?>
                                                                    </div>
                                                                <?php endif; ?>
                                                                <h4 class="copy--title"><?= $choice_title ?></h4>
                                                            </div>
                                                            <?php if ($choice_subtitle): ?>
                                                                <div class="copy--body">
                                                                    <div class="wysiwyg">
                                                                        <?= $choice_title ?>
                                                                    </div>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </label>
                                                </div>
                                            </li>
                                        <?php
                                        endwhile; ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php
                  endwhile;
                endif; ?>
            </div>

            <div class="form align--center" data-active="false">
                <div class="layout-row" data-gap="md">
                    <?php if ($has_form_title): ?>
                        <div class="copy">
                            <div class="copy--header">
                                <h2 class="copy--title"><?= $form_title ?></h2>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($form_id): ?>
                        <div class="card form-card">
                            <div class="preview">
                                <div class="copy variant--subsection">
                                    <div class="copy--header">
                                        <div class="copy--title"><?php _e(
                                          'Review your choices',
                                          'shooga-cubes-controls'
                                        ); ?></div>
                                    </div>
                                </div>
                                <div class="preview--content"></div>
                            </div>
                            <div class="form">
                                <?= do_shortcode("[formidable id=$form_id]") ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="controls variant--space-between" data-js-target="concierge.controls">
                <button class="button variant--secondary --prev">
                    <?= get_icon('chevron-left') ?>
                    <span><?php _e('Previous', 'shooga-cubes-controls'); ?></span>
                </button>
                <button class="button variant--primary --next">
                    <span><?php _e('Next', 'shooga-cubes-controls'); ?></span>
                    <?= get_icon('chevron-right') ?>
                </button>
                <button class="button variant--primary --submit">
                    <span><?php _e('Submit', 'shooga-cubes-controls'); ?></span>
                </button>
            </div>
        </div>

    </div>
</div>
