<?php

/**
 * Component: PLX 19 - Pricing Plan
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'key' => '',
  'align' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="layout-block">
    <div class="layout-row">

        <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

        <?php if ($posts_query->have_posts()): ?>
            <?php while ($posts_query->have_posts()): ?>
              <?php
              $posts_query->the_post();
              $price_model = get_field('price_model');
              $price_model_discount = get_field('price_model_discount');
              $price_currency = get_field('price_currency');
              $price_currency_details = get_currency_details($price_currency);
              $price_currency_symbol = $price_currency_details['symbol'];
              $price_currency_code = $price_currency_details['code'];
              ?>

              <div class="price-table" data-js-controller="pricingTable">
                <div class="layout-row align--center" data-gap="lg">

                    <?php if ($price_model === 'subscription'): ?>
                      <div
                        class="label-switch"
                        role="radiogroup"
                        data-js-target="pricingTable.switch"
                      >
                        <div class="label-switch-item">
                          <label>
                            <input
                              type="radio"
                              name="pricing-model-<?= $props['key'] ?>"
                              value="month"
                              checked
                            >
                            <?php _e('Monthly', 'shooga-cubes-controls'); ?>
                          </label>
                        </div>
                        <div class="label-switch-item">
                          <label>
                            <input
                              type="radio"
                              name="pricing-model-<?= $props['key'] ?>"
                              value="year"
                            >
                            <?php _e('Yearly', 'shooga-cubes-controls'); ?>
                            <?php if (!empty($price_model_discount)): ?>
                                <span class="discount"><?= esc_html($price_model_discount) ?></span>
                            <?php endif; ?>
                          </label>
                        </div>
                      </div>
                    <?php endif; ?>

                    <div class="price-table-columns" data-js-target="pricingTable.columns">
                        <?php if (have_rows('price_column')): ?>
                          <?php while (have_rows('price_column')): ?>
                            <?php the_row(); ?>
                            <?php
                            $content = get_sub_field('price_column_content');
                            $options = get_sub_field('price_column_options');
                            $column_list = $content['column_list'] ?: [];
                            $column_button_group = $content['column_button_group'] ?: [];
                            $column_featured = $options['column_is_featured'] ? 'variant--featured' : null;
                            ?>

                            <div class="price-table-column">
                              <div class="<?= cn('card price-card', $column_featured) ?>" data-variant="nopad">
                                <div class="card--header">
                                  <div class="copy variant--subsection price-card_copy">
                                    <div class="copy--header">
                                        <div class="copy--caption">
                                          <h3>
                                            <strong><?= $content['column_title'] ?></strong>
                                          </h3>
                                          <div class="wysiwyg">
                                            <?= $content['column_subtitle'] ?>
                                          </div>
                                        </div>
                                        <div class="copy--title">
                                          <?php if ($price_model === 'subscription'): ?>
                                            <div
                                              class="price price-monthly"
                                              aria-hidden="false"
                                              data-js-target="pricingTable.price.month"
                                            >
                                              <p><?= "{$price_currency_symbol}{$content['column_price_monthly']}" ?> </p>
                                              <span class="detail">
                                                <!-- <p><?= $price_currency_code ?></p> -->
                                                <p><?php _e('/ per month', 'shooga-cubes-controls'); ?></p>
                                              </span>
                                            </div>
                                            <div
                                              class="price price-yearly"
                                              aria-hidden="true"
                                              data-js-target="pricingTable.price.year"
                                              data-visible="false"
                                            >
                                              <p><?= "{$price_currency_symbol}{$content['column_price_yearly']}" ?> </p>
                                              <span class="detail">
                                                <!-- <p><?= $price_currency_code ?></p> -->
                                                <p><?php _e('/ per year', 'shooga-cubes-controls'); ?></p>
                                              </span>
                                            </div>
                                          <?php else: ?>
                                            <div class="price price-standard">
                                              <p><?= "{$price_currency_symbol}{$content['column_price_standard']}" ?> </p>
                                              <?php if (!empty($content['column_price_detail'])): ?>
                                                <span class="detail">
                                                  <?= $content['column_price_detail'] ?>
                                                </span>
                                              <?php endif; ?>
                                            </div>
                                          <?php endif; ?>
                                        </div>
                                    </div>
                                  </div>
                                </div>

                                <div class="card--content">
                                  <?php if (!empty($column_list)): ?>
                                    <div class="list">
                                      <ul class="list--list">
                                        <?php foreach ($column_list as $i => $list): ?>
                                          <li class="list--item">
                                            <span class="list--icon">
                                              <?= get_icon('check') ?>
                                            </span>
                                            <?= $list['column_list_item'] ?>
                                          </li>
                                        <?php endforeach; ?>
                                      </ul>
                                    </div>
                                  <?php endif; ?>
                                </div>

                                <?php if (!empty($column_button_group)): ?>
                                  <div class="card--footer">
                                    <?php foreach ($column_button_group as $i => $button): ?>
                                      <?php $button_variant = match ($button['variant'] ?? null) {
                                        '0' => 'variant--primary',
                                        '1' => 'variant--secondary',
                                        '2' => 'variant--ghost',
                                        '3' => 'variant--white',
                                        '4' => 'variant--link',
                                        default => null,
                                      }; ?>
                                      <?php if ($button['link']): ?>
                                          <a
                                            class="<?= cn('button', $button_variant) ?>"
                                            href="<?= esc_url($button['link']['url']) ?>"
                                            target="<?= $button['link']['target'] ?>"
                                          >
                                            <?= $button['link']['title'] ?>
                                          </a>
                                      <?php endif; ?>
                                    <?php endforeach; ?>
                                  </div>
                                <?php endif; ?>
                              </div>
                            </div>
                          <?php endwhile; ?>
                        <?php endif; ?>
                    </div>

                </div>
              </div>
            <?php endwhile; ?>

        <?php else: ?>
          <?php component('error-boundary', [
            'title' => 'No Posts Found',
            'details' => 'Add posts, or remove this block.',
          ]); ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>

    </div>
</div>
