<?php

/**
 * Component: PLX 20 - FAQ
 * Variant: Aside
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'accordion_mode' => '',
  'aside_image' => null
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="wrapper">
  <div class="layout_grid">

    <div class="col-title">
      <div class="col-title_inner">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section']); ?>
      </div>
    </div>
    <div class="col-image">
      <?php if($props['aside_image']) : ?>
      <div class="figure" data-variant="fill">
        <div class="figure_inner">
          <img
            src="<?= esc_url($props['aside_image']['url']) ?>"
            alt="<?= esc_attr($props['aside_image']['alt']) ?>"
          >
        </div>
      </div>
      <?php endif;?>
    </div>
    <div class="col-content">
      <?php if ($posts_query->have_posts()): ?>
        <div
          class="accordion"
          data-js-controller="accordion"
          <?= $props['accordion_mode'] === 'multi' ? 'data-js-allow-multiple-expanded' : null ?>
        >
          <?php while ($posts_query->have_posts()): ?>
            <?php
            $posts_query->the_post();
            $title = esc_html(get_the_title());
            $content = get_field('accordion_content');
            ?>
            <div
              class="accordion-item"
              data-js-controller="accordionItem"
              aria-expanded="false"
            >
              <h3 class="accordion-item_heading">
                <button data-js-target="accordionItem.toggle" aria-expanded="false">
                  <span class="icon-plus-circle" aria-hidden="true"></span>
                  <span class="label"><?= $title ?></span>
                </button>
              </h3>
              <section class="accordion-item_content" data-js-target="accordionItem.content">
                <div class="copy">
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $content ?></div>
                  </div>
                </div>
              </section>
            </div>
          <?php endwhile; ?>
        </div>
      <?php else: ?>
        <?php component('error-boundary', [
          'title' => 'No Posts Found',
          'details' => 'Add posts, or remove this block.',
        ]); ?>
      <?php endif; ?>
      <?php wp_reset_postdata(); ?>
    </div>

  </div>
</div>
