<?php

/**
 * Component: PLX 20 - FAQ
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'accordion_mode' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="layout-block">
  <div class="layout-row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section']); ?>

    <?php if ($posts_query->have_posts()): ?>
      <div
        class="accordion"
        data-js-controller="accordion"
        <?= $props['accordion_mode'] === 'multi' ? 'data-js-allow-multiple-expanded' : null ?>
      >
        <?php while ($posts_query->have_posts()): ?>
          <?php
          $posts_query->the_post();
          $title = esc_html(get_the_title());
          $content = get_field('accordion_content');
          ?>
          <div
            class="accordion-item"
            data-js-controller="accordionItem"
            aria-expanded="false"
          >
            <h3 class="accordion-item_heading">
              <button data-js-target="accordionItem.toggle" aria-expanded="false">
                <span class="label"><?= $title ?></span>
                <?= get_icon('chevron-down') ?>
              </button>
            </h3>
            <section class="accordion-item_content" data-js-target="accordionItem.content">
              <div class="copy">
                <div class="copy--body">
                  <div class="wysiwyg"><?= $content ?></div>
                </div>
              </div>
            </section>
          </div>
        <?php endwhile; ?>
      </div>
    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
