<?php

/**
 * Component: PLX 21 - Steps
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'steps' => [],
  'align' => '',
  'type' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$steps = $props['steps'];
?>

<div class="layout-block">
  <div class="layout-row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <div class="steps">
      <?php foreach ($steps as $index => $step): ?>
        <div class="step">
          <div class="step_counter">
            <span class="index"><?= sprintf('%02d', $index + 1) ?></span>
          </div>
          <?php component('copy', [
            'has_caption' => !empty($step['label']),
            'caption' => $step['label'],
            'has_body' => !empty($step['description']),
            'body' => $step['description'],
            'type' => 'variant--detail',
            'align' => $props['align'],
          ]); ?>
        </div>
      <?php endforeach; ?>
    </div>

  </div>
</div>
