<?php

/**
 * Component: PLX 23 - Blog
 * Variant: BLOX
 */

$args = $args ?? [];
[
  'content' => [
    'has_caption' => $has_caption,
    'caption' => $caption,
    'has_title' => $has_title,
    'title' => $title,
    'has_body' => $has_body,
    'body' => $body,
  ],
  'query_args' => $query_args,
  'type' => $type,
] = $args;

$query = new WP_Query($query_args);
?>

<div class="layout-block">
  <div class="layout-row">

    <div class="<?= cn('copy variant--section') ?>">
      <?php if ($has_caption || $has_title): ?>
        <div class="copy--header">
          <?php if ($has_caption): ?>
            <p class="copy--caption"><?= $caption ?></p>
          <?php endif; ?>
          <?php if ($has_title): ?>
            <h2 class="copy--title"><span><?= $title ?></span></h2>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <?php if ($has_body): ?>
        <div class="copy--body">
          <div class="wysiwyg"><?= $body ?></div>
        </div>
      <?php endif; ?>
    </div>

    <?php if ($query->have_posts()): ?>
      <div class="blog-layout">
        <?php while ($query->have_posts()):
          $query->the_post();
          $card_data = [
            'content' => [
              'date' => get_localized_date(),
              'title' => get_the_title(),
              'link' => get_permalink(),
              'feat_image' => get_feat_img(),
              'author_image' => get_field('user_image', 'user_' . get_post_field('post_author')),
              'author_name' => get_author_full_name(),
              'options' => [
                'show_author' => false,
              ],
            ],
            'type' => $type,
            'options' => [
              'show_author' => false,
            ],
          ];

          get_template_part('components/blog/blog-card', null, $card_data);
        endwhile; ?>
      </div>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
