<?php

/**
 * Component: PLX 27 - Team
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'type' => '',
  'align' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="wrapper">
  <div class="layout_row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <?php if ($posts_query->have_posts()): ?>
      <div class="team_layout">
        <?php while ($posts_query->have_posts()): ?>
         <?php $posts_query->the_post(); ?>
            <?php
            $name = get_the_title();
            $link = get_the_permalink();
            $content = get_field('content');
            $figure = get_field('figure');
            $has_child = get_field('has_child');
            $child_options = get_field('child_options');
            ?>
            <div class="team-member">
              <div
                class="team-member_headshot"
                data-x-data="{ modalExpanded: false }"
                data-x-on:click="modalExpanded = !modalExpanded"
                data-x-bind:aria-expanded="modalExpanded"
              >
                <div class="team-member_media">
                  <?php component('figure', [
                    'src' => $figure,
                    'type' => 'fill',
                  ]); ?>
                </div>

                <?php if (!$has_child && !empty($content['description'])): ?>
                  <div class="team-member_modal" data-x-cloak>
                    <div class="team-member_modal_indicator" data-x-bind:aria-label="modalExpanded ? 'Close' : 'Open'">
                      <span class="bg" aria-hidden="true"></span>
                      <span class="line" aria-hidden="true" data-position="x"></span>
                      <span class="line" aria-hidden="true" data-position="y"></span>
                    </div>
                    <div class="team-member_modal_content">
                      <div class="wysiwyg">
                        <?= $content['description'] ?>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
              <div class="team-member_content">
                <div class="stack" data-gap="4" data-align="start">
                  <?php component('typography/heading', [
                    'size' => 4,
                    'as' => 'h3',
                    'text' => esc_html($name),
                  ]); ?>
                  <?php if (!empty($content['position'])): ?>
                    <p class="position"><?= $content['position'] ?></p>
                  <?php endif; ?>
                  <?php if ($has_child): ?>
                    <div class="controls">
                      <?php component('button', [
                        'type' => 'link',
                        'link' => [
                          'title' => $child_options['label'],
                          'url' => $link,
                        ],
                      ]); ?>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
        <?php endwhile; ?>
      </div>
    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
