<?php

/**
 * Button Group
 *
 * @param array $args
 */

$_defaults = [];

/**
 * Merge passed arguments with defaults
 */
$button_group = wp_parse_args($args ?? [], $_defaults);
?>

<div class="button-group">
  <?php foreach ($button_group as $button):
    if (empty($button) || empty($button['link']) || empty($button['link']['url']) || empty($button['link']['title'])) {
      continue; // skip button if essential data is missing
    }

    $button_type = match ($button['variant'] ?? null) {
      '0' => 'primary',
      '1' => 'secondary',
      '2' => 'ghost',
      '3' => 'white',
      '4' => 'link',
      '5' => 'outline',
      '6' => 'glass',
      '7' => 'accent',
      default => null,
    };

    component('button', [
      'type' => $button_type,
      'size' => 'medium',
      'link' => [
        'title' => $button['link']['title'],
        'url' => $button['link']['url'],
        'target' => !empty($button['link']['target']) ? $button['link']['target'] : null,
      ],
    ]);
  endforeach; ?>
</div>
