<?php

/**
 * Card
 *
 * Serves as a generic card
 *
 * @param array $args
 */

$_defaults = [
  'type' => '',
  'align' => '',
  'href' => '',
  'icon' => [
    'provider' => '',
    'src' => '',
    'color' => 'default',
    'has_background' => false,
    'has_border' => false,
    'shape' => '',
    'size' => 32,
  ],
  'image' => [],
  'heading' => '',
  'description' => '',
  'cta' => 'Learn more',
  'className' => '',
  'inlineStyles' => [],
  'has_border' => false,
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<div
  class="<?= cn('card', $className, ['has-link' => !empty($href)], ['has-border' => $has_border]) ?>"
  <?= attr_if('data-variant', $type) ?>
  <?= attr_if('data-align', $align) ?>
>
  <?php if (!empty($icon['src']['type'])): ?>
    <div class="card_icon">
      <?php component('icon', [
        'data' => ['provider' => $icon['provider'], 'src' => $icon['src']],
        'has_background' => $icon['has_background'],
        'has_border' => $icon['has_border'],
        'shape' => $icon['shape'],
        'size' => $icon['size'],
      ]); ?>
    </div>
  <?php endif; ?>

  <?php if ($image['url']): ?>
  <div class="figure" data-shape="rounded">
    <div class="figure_inner">
      <img
        src="<?= esc_url($image['url']) ?>"
        alt="<?= esc_attr($image['alt']) ?>"
      />
    </div>
  </div>
  <?php endif;?>

  <div class="card_body">
    <?php component('copy', [
      'has_title' => !empty($heading),
      'title' => $heading,
      'has_body' => !empty($description),
      'body' => $description,
      'type' => 'variant--subsection',
    ]); ?>
  </div>

  <?php if (!empty($href)): ?>
    <div class="card_action">
      <a href="<?= $href ?>" class="link variant--cta card_link">
        <?= esc_html($cta) ?>
        <?= get_icon('arrow-expand-right') ?>
      </a>
    </div>
  <?php endif; ?>
</div>
