<?php

/**
 * CTA Banner
 * Use the CTA banner component to highlight and create urgency around user actions
 *
 * @param array $args
 */

$_defaults = [
  /**
   * Specify the variant
   */
  'type' => 'default',
  /**
   * The horizontal positioning of content within the banner component
   */
  'align' => '',
  /**
   * Custom class to pass to the component
   */
  'className' => '',
  /**
   * Content to include within the banner component
   */
  'content' => [],
  /**
   * A flag used to apply a border
   */
  'has_border' => false,
  /**
   * A flag used to apply a shadow
   */
  'has_shadow' => false,
  /**
   * A flag used to apply a background
   */
  'has_background' => false,
  /**
   * Optional, custom background color
   */
  'background_color' => '',
  /**
   * Optional, custom background image
   */
  'background_image' => [
    'size' => 'cover',
    'position' => 'center',
    'src' => '',
  ],
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = wp_parse_args($args ?? [], $_defaults);
extract($params);

/**
 * Inline styles
 */
$cta_banner_styles = [
  '--cta-banner-bg' => $background_color,
];
$cta_banner_styles = array_filter($cta_banner_styles, fn($value) => !empty($value));
$cta_banner_declarations = array_map(
  fn($value, $prop) => sprintf('%s: %s', $prop, esc_attr($value)),
  $cta_banner_styles,
  array_keys($cta_banner_styles)
);
$card_inline_styles = $cta_banner_declarations ? 'style="' . implode('; ', $cta_banner_declarations) . '"' : '';
?>

<div
  class="<?= cn('cta-banner', $className, ['has-shadow' => !empty($has_shadow)]) ?>"
  data-variant="<?= esc_attr($type) ?>"
  <?= $card_inline_styles ?>
>
  <div
    class="<?= cn('cta-banner_container', ['has-border' => !empty($has_border)]) ?>"
  >
    <div class="cta-banner_content">
      <?php component('copy', [...$content, 'type' => 'variant--cta', 'align' => $align]); ?>
    </div>
  </div>
</div>
