<?php
/**
 * Slide Card (Swiper Slide)
 * @param array $args
 */

$_defaults = [
  'id' => 0,
  'title' => '',
  'href' => '',
  'terms' => [],
  'figure' => '',
];

$params = array_merge_deep($_defaults, $args ?? []);
extract($params);

$term_ids = is_array($terms) ? implode(',', wp_list_pluck($terms, 'term_id')) : '';
?>

<div class="swiper-slide" data-terms="<?= esc_attr($term_ids) ?>">
  <a href="<?= $href ?>">
    <div class="layout_row" data-gap="small">

      <div class="copy variant--detail">
        <div class="copy--header">
          <?php if (!empty($terms)): ?>
            <div class="copy--caption">
              <ul class="c3-current-filter-list">
                <span class="font-normal"><?php _e('Type: ', 'shooga-cubes-theme'); ?></span>
                <?php foreach ($terms as $term): ?>
                  <li><?= esc_html($term->name) ?></li>
                <?php endforeach; ?>
              </ul>
            </div>
          <?php endif; ?>

          <?php if (!empty($title)): ?>
            <h3 class="copy--title"><?= esc_html($title) ?></h3>
          <?php endif; ?>
        </div>
      </div>

      <div class="canvas">
        <?php if (!empty($figure['provider'])): ?>
          <?php component('figure', [
            'src' => $figure,
            'type' => 'fill',
            'shape' => 'rounded',
          ]); ?>
        <?php elseif (!empty($figure)): ?>
          <div class="figure" data-variant="fill" data-shape="rounded">
            <div class="figure_inner">
              <img src="<?= esc_url($figure) ?>">
            </div>
          </div>
        <?php else: ?>
          <span class="figure-placeholder" data-label="Upload Image"></span>
        <?php endif; ?>
      </div>

    </div>
  </a>
</div>
