<?php

/**
 * Figure
 * @param array $args
 */

$_defaults = [
  'type' => 'default',
  'shape' => '',
  'className' => '',
  'src' => [],
  'has_shadow' => false,
  'has_border' => false,
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = wp_parse_args($args ?? [], $_defaults);
extract($params);
?>

<?php if (!empty($src)): ?>
  <div
    class="<?= cn('figure', $className, ['has-shadow' => $has_shadow, 'has-border' => $has_border]) ?>"
    <?= attr_if('data-variant', $type) ?>
    <?= attr_if('data-shape', $shape) ?>
  >
    <?= get_figure($src) ?>
  </div>
<?php endif; ?>
