<?php

/**
 * Component: Header
 * Variant: Default
 */

$app = get_app_data();
$global = $app['global_data'] ?? [];
$header = $app['header_data'] ?? [];
$home_url = home_url('/');
?>

<div class="<?= cn('header-layout', $header['align']) ?>">

  <div class="header-brand">
    <?php if (!empty($global['brand_logo'])): ?>
      <a class="brand-logo" href="<?= esc_url($home_url) ?>">
        <?php if ($header['theme'] == 'dark' || ($header['theme'] == null && $global['default_theme'] == 'dark') ) : ?>
          <img src="<?= $global['brand_logo_alt'] ?>" alt="<?= $global['brand_name'] ?> logo"
               loading="eager"/>
        <?php else: ?>
          <img src="<?= $global['brand_logo'] ?>" alt="<?= $global['brand_name'] ?> logo"
               loading="eager"/>
        <?php endif; ?>
      </a>
    <?php else: ?>
      <a class="brand-name" href="<?= esc_url($home_url) ?>">
        <h1><?= $global['brand_name'] ?></h1>
      </a>
    <?php endif; ?>
  </div>

  <nav class="header-nav_main">
    <ul class="header-nav_main-list">
      <?php foreach ($header['menu_main'] as $item): ?>
        <li tabindex="-1" class="<?= cn('header-nav_main-list-item') ?>">
          <?php if ($item->children): ?>
            <span class='link'><?= $item->title ?></span>
            <ul tabindex="-1" class="megamenu">
              <li>
                <div class="wrapper">
                  <?php foreach ($item->children as $key => $child): ?>
                    <div class="group">
                      <div class="heading">
                        <?php if ($child->url == '#'): ?>
                          <span class="link"><?= $child->title ?></span>
                        <?php else: ?>
                          <a href='<?= $child->url ?>'><?= $child->title ?></a>
                        <?php endif; ?>
                      </div>
                      <ul class="links">
                        <?php foreach ($child->children ?: [] as $grandchild): ?>
                          <li><a href='<?= $grandchild->url ?>'><?= $grandchild->title ?>
                              <span class="description"><?= $grandchild->description ?></span>
                            </a></li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  <?php endforeach; ?>
                </div>
              </li>
            </ul>
          <?php else: ?>
            <a class="link" href='<?= $item->url ?>'><?= $item->title ?></a>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>
  </nav>

  <nav class="header-nav_cta">
    <ul class="header-nav_cta-list">
      <?php foreach ($header['menu_cta'] as $item): ?>
        <li tabindex="-1" class="<?= cn('header-nav_cta-list-item') ?>">
          <a class="<?= cn(
            'button',
            end($header['menu_cta']) === $item ? 'variant--primary' : 'variant--ghost',
          ) ?>" href='<?= $item->url ?>'>
            <?= $item->title ?>
          </a>
        </li>
      <?php endforeach; ?>
    </ul>

    <?php
    $languages = apply_filters('wpml_active_languages', null, ['skip_missing' => 1]);
    if (!empty($languages) && count($languages) > 1) {
      $current_lang = apply_filters('wpml_current_language', null);
      unset($languages[$current_lang]);
      $second_lang = reset($languages);
      ?>
      <div class="header-nav_cta-lang">
        <div class="wpml-ls-link">
          <a href="<?= esc_url($second_lang['url']); ?>">
            <?= esc_html($second_lang['native_name']); ?>
          </a>
        </div>
      </div>
    <?php } ?>
  </nav>

  <div class="header-mobile-menu" data-js-target="header.mobileMenu">
    <button
      class="mobile-menu-toggle"
      data-expanded="false"
      aria-label="Open menu"
      type="button"
    >
      <span class="line" data-position="top"></span>
      <span class="line" data-position="bottom"></span>
    </button>

    <div class="mobile-menu-root" data-lenis-prevent>
      <nav class="mobile-menu-wrapper">
        <section class="mobile-menu-nav_main">
          <ul class="stack">
            <?php foreach ($header['menu_main'] as $item): ?>
              <li class="header-nav_main-list-item">
                <?php if ($item->children): ?>
                  <span class='link'><?= $item->title ?></span>
                  <ul>
                    <li>
                      <div class="wrapper">
                        <?php foreach ($item->children as $key => $child): ?>
                          <div class="group">
                            <div class="heading">
                              <?php if ($child->url == '#'): ?>
                                <span class="link"><?= $child->title ?></span>
                              <?php else: ?>
                                <a href='<?= $child->url ?>'><?= $child->title ?></a>
                              <?php endif; ?>
                            </div>
                            <ul class="links">
                              <?php foreach ($child->children ?: [] as $grandchild): ?>
                                <li><a href='<?= $grandchild->url ?>'><?= $grandchild->title ?>
                                    <span class="description"><?= $grandchild->description ?></span>
                                  </a></li>
                              <?php endforeach; ?>
                            </ul>
                          </div>
                        <?php endforeach; ?>
                      </div>
                    </li>
                  </ul>
                <?php else: ?>
                  <a class="link" href='<?= $item->url ?>'><?= $item->title ?></a>
                <?php endif; ?>
              </li>
            <?php endforeach; ?>
          </ul>
        </section>

        <section class="mobile-menu-nav_cta">
          <div class="stack">
            <?php foreach ($header['menu_cta'] as $item): ?>
              <a class="<?= cn(
                'button',
                end($header['menu_cta']) === $item ? 'variant--primary' : 'variant--secondary',
              ) ?>" href='<?= $item->url ?>'>
                <?= $item->title ?>
              </a>
            <?php endforeach; ?>
          </div>
        </section>
      </nav>
    </div>
  </div>
</div>
