<?php

/**
 * Icon
 * @param array $args
 */

$_defaults = [
  'type' => 'default',
  'size' => 32,
  'shape' => '',
  'className' => '',
  'data' => [
    'provider' => '',
    'src' => '',
  ],
  'has_background' => false,
  'has_border' => false,
  'has_shadow' => false,
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<div
  class="<?= cn('icon_wrapper', $className, [
    'has-background' => $has_background,
    'has-border' => $has_border,
    'has-shadow' => $has_shadow,
  ]) ?>"
  <?= attr_if('data-variant', $type) ?>
  <?= attr_if('data-shape', $shape) ?>
  <?= attr_if('data-size', $size) ?>
>
  <?php if ($data['provider'] == 'system'): ?>
    <?= get_icon($data['src']) ?>
  <?php elseif ($data['provider'] == 'acf'): ?>
    <?= get_acf_icon($data['src']) ?>
  <?php endif; ?>
</div>
