<?php
// Get popup options from ACF options page

$args=[
  'content' => [
    'has_caption' => get_field('has_caption', 'option'),
    'caption'     => get_field('caption', 'option'),
    'has_title'   => get_field('has_title', 'option'),
    'title'       => get_field('title', 'option'),
    'has_body'    => get_field('has_body', 'option'),
    'body'        => get_field('body', 'option'),
    'has_footer'  => get_field('has_footer', 'option'),
    'button_group' => get_field('button_group', 'option')
  ],
  'items'       => get_field('item', 'option'), // Repeater items
  'figure' => get_field('figure', 'option'),
];

$popup_options = get_field('popup_options', 'option') ?: [];
$popup_type = $popup_options['popup_type'] ?? 'timed';
$popup_time = (int) ($popup_options['popup_time'] ?? 0);

?>

<div class="layout-block popup-container">
  <div class="popup"
       data-js-target="popup.container"
       data-trigger="<?= esc_attr($popup_type); ?>"
       data-time="<?= esc_attr($popup_time); ?>">
    <div class="wrapper">
      <div class="layout_row">
      <?php component('copy', [...$args['content'], 'type' => 'variant--section', 'figure' => $args['figure']]); ?>
      <div
        class="<?= cn('text-image_layout', /*$props['item_align'], $props['item_reverse']*/) ?>"
      >
        <?php if (!empty($args['items'])): ?>
          <div class="content">
            <div class="list">
              <ul class="list--list">
                <?php foreach ($args['items'] as $item): ?>
                  <li class="list--item">
                    <?php component('copy', [
                      'has_title' => $item['has_title'],
                      'title' => $item['title'],
                      'has_body' => $item['has_body'],
                      'body' => $item['body'],
                      'has_footer' => $item['has_footer'],
                      'button_group' => $item['button_group'],
                    ]); ?>
                  </li>
                <?php endforeach; ?>
              </ul>
            </div>
          </div>
        <?php endif; ?>

        <div class="visual">
          <?php if (!empty($args['figure']['provider'])): ?>
            <?php component('figure', [
              'src' => $args['figure'],
              'type' => 'fill',
              'shape' => 'rounded',
              'has_shadow' => true,
            ]); ?>
          <?php elseif (!empty($args['figure'])): ?>
            <div class="figure has-shadow" data-variant="fill" data-shape="rounded">
              <div class="figure_inner">
                <img src="<?= esc_url($args['figure']['url']) ?>">
              </div>
            </div>
          <?php else: ?>
            <span class="figure-placeholder" data-label="Upload Image"></span>
          <?php endif; ?>
        </div>
      </div>
      <button class="popup-close">×</button>
    </div>
    </div>
  </div>
</div>

<!--$popupContent = '';
if ($popup_options_data['has_caption']) {
$popupContent .= '<div class="popup-caption">' . esc_html($popup_options_data['caption']) . '</div>';
}
if ($popup_options_data['has_title']) {
$popupContent .= '<h2 class="popup-title">' . esc_html($popup_options_data['title']) . '</h2>';
}
if ($popup_options_data['has_body']) {
$popupContent .= '<div class="popup-body">' . wp_kses_post($popup_options_data['body']) . '</div>';
}
if ($popup_options_data['has_footer'] && !empty($popup_options_data['buttons'])) {
$popupContent .= '<div class="popup-footer">';
  foreach ($popup_options_data['buttons'] as $button) {
  $link = $button['link'] ?? '#';
  $text = $link ? esc_html($button['link']['title'] ?? 'Button') : 'Button';
  $url = $link ? esc_url($link['url'] ?? '#') : '#';
  $popupContent .= '<a href="' . $url . '" class="button">' . $text . '</a>';
  }
  $popupContent .= '</div>';
}-->
