<?php
/**
 * Terms Filter
 * @param array $args
 */

$_defaults = [
  'className' => '',
  'target' => '',
  'ajax' => [
    'action' => '',
    'callback' => '',
    'container' => '',
    'query_args' => '',
  ],
  'terms' => [],
];

$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<div
  class="<?= cn('c3-filter', $className) ?>"
  data-js-controller="dynamicTwo.filter"
>
  <div class="c3-filter-list">

    <!-- "All" Filter -->
    <div
      class="filter"
      data-active="true"
      data-filter-id="all"
      data-js-target="<?= $target ?>"
      data-ajax-url="<?= esc_url(admin_url('admin-ajax.php')) ?>"
      data-ajax-action-name="<?= esc_attr($ajax['action']) ?>"
      data-ajax-callback="<?= esc_attr($ajax['callback']) ?>"
      data-ajax-container="<?= esc_attr($ajax['container']) ?>"
      data-ajax-query-args='<?= wp_json_encode($ajax['query_args'], JSON_HEX_APOS | JSON_HEX_QUOT) ?>'
      data-ajax-nonce="<?= wp_create_nonce('filter-posts-by-term') ?>"
    >
      <span><?php _e('All', 'plexible-theme-terms_controls'); ?></span>
    </div>

    <!-- Dynamic Term Filters -->
    <?php foreach ($terms as $term): ?>
      <div
        class="filter"
        data-active="false"
        data-filter-id="<?= esc_attr($term->term_id) ?>"
        data-js-target="<?= $target ?>"
        data-ajax-url="<?= esc_url(admin_url('admin-ajax.php')) ?>"
        data-ajax-action-name="<?= esc_attr($ajax['action']) ?>"
        data-ajax-callback="<?= esc_attr($ajax['callback']) ?>"
        data-ajax-container="<?= esc_attr($ajax['container']) ?>"
        data-ajax-query-args='<?= wp_json_encode($ajax['query_args'], JSON_HEX_APOS | JSON_HEX_QUOT) ?>'
        data-ajax-nonce="<?= wp_create_nonce('filter-posts-by-term') ?>"
      >
        <span><?= esc_html($term->name) ?></span>
      </div>
    <?php endforeach; ?>

  </div>
</div>
