<?php

/**
 * Custom toolbar
 *
 * Serves as a replacement to the default adminbar
 */

$toolbar_settings = get_theme_option('toolbar');

$toolbar_apps = [
  'home' => [
    'show' => true,
    'show_button' => false,
    'render' => function () {
      ?>
      <div data-toolbar-app="home" data-visible="false">
        <header>
          <section class="version">
            <h1>Plexible</h1>
            <div class="toolbar-badge">
              <?= esc_html(THEME_VERSION) ?>
            </div>
          </section>
          <button>Copy debug info</button>
        </header>
        <hr>
        <div class="main-container">
          <section class="links">
            <a href="mailto:dev@plexible.com"><?= get_icon('bug') ?> Report a bug</a>
            <a href="mailto:dev@plexible.com"><?= get_icon('lightbulb') ?> Feedback</a>
            <a href="mailto:dev@plexible.com"><?= get_icon('document-search') ?> Documentation</a>
          </section>
        </div>
      </div>
      <?php
    },
  ],
  'dev' => [
    'show' => !empty($toolbar_settings['dev']),
    'show_button' => true,
    'render' => function () {
      ?>
      <div
        data-toolbar-app="dev"
        data-visible="false"
        data-x-data
      >
        <header>
          <h1>Dev Settings</h1>
        </header>
        <hr>
        <div class="main-container">
          <label class="setting-row">
            <div class="stack">
              <h3>Grid Overlay</h3>
              <p>Enables a grid overlay for layout debugging.</p>
            </div>
            <input type="checkbox" data-x-model="$store.devSettings.gridOverlay" />
          </label>
          <label class="setting-row">
            <div class="stack">
              <h3>Block Inspector</h3>
              <p>Enables inspector mode to view active blocks.</p>
            </div>
            <input type="checkbox" data-x-model="$store.devSettings.blockInspector" />
          </label>
        </div>
      </div>
      <?php
    },
  ],
];

if (is_user_logged_in() && current_user_can('edit_posts')): ?>
  <?php
  global $post;
  $post_id = $post->ID ?? 0;
  $edit_link = get_edit_post_link($post_id);
  $site_name = get_bloginfo('name');
  $dashboard_link = admin_url();
  $current_user = wp_get_current_user();
  $user_display = $current_user->display_name;
  $profile_link = admin_url('profile.php');
  ?>
  <div class="toolbar is-visible" data-js-controller="admin-bar" data-show="tablet">
    <div class="toolbar_root" data-placement="bottom-right">
      <ul class="toolbar_items">
        <li class="item">
          <button data-toolbar-app="home"><?= get_icon('plexible') ?></button>
        </li>
        <li class="separator"></li>
        <li class="item">
          <a href="<?= esc_url($dashboard_link) ?>"><?= esc_html($site_name) ?></a>
        </li>
        <li class="item">
          <a href="<?= esc_url($edit_link) ?>">Edit Page</a>
        </li>
        <li class="item">
          <a href="<?= esc_url($profile_link) ?>"><?= esc_html($user_display) ?></a>
        </li>
        <li class="separator"></li>
        <?php foreach ($toolbar_apps as $slug => $app): ?>
          <?php
          $should_show = is_callable($app['show']) ? call_user_func($app['show']) : (bool) $app['show'];
          if (!$should_show || empty($app['show_button'])) {
            continue;
          }
          ?>
          <li class="item">
            <button data-toolbar-app="<?= esc_attr($slug) ?>">
              <?= esc_html(ucfirst($slug)) ?>
            </button>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>

    <div class="toolbar_canvas" data-visible="false">
      <div class="toolbar_window">
        <?php foreach ($toolbar_apps as $slug => $app):
          $should_show = is_callable($app['show']) ? call_user_func($app['show']) : (bool) $app['show'];
          if (!$should_show) {
            continue;
          }
          call_user_func($app['render']);
        endforeach; ?>
      </div>
    </div>
  </div>

  <?php if (!empty($toolbar_settings['dev'])): ?>
    <?php component('grid-overlay'); ?>
  <?php endif; ?>
<?php endif; ?>
