<?php
/*
 * Cube 21 : Tabs
 *
 */

function cubes_cube_21(array $props): string {
  ob_start(); ?>
    <section class="section" data-cube="21">
      <div class="layout-block">
        <div class="layout-row">
          <div class="copy variant--section">
            <?php if ($props['has_caption'] || $props['has_title']): ?>
              <div class="copy--header">
                  <?php if ($props['has_caption']): ?>
                    <p class="copy--caption"><?= $props['caption'] ?></p>
                  <?php endif; ?>
                  <?php if ($props['has_title']): ?>
                    <h2 class="copy--title"><?= $props['title'] ?></h2>
                  <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>

          <?php if (!empty($props['accordion_items'])): ?>
            <div class="accordion" data-js-controller="accordion"
              <?= $props['accordion_mode'] === 'multi' ? 'data-js-allow-multiple-expanded' : null ?>
            >
              <?php foreach ($props['accordion_items'] as $item): ?>
                <?php
                $title = $item['item_title'];
                $content = $item['item_content'];
                ?>
                <div 
                  class="accordion-item" 
                  data-js-controller="accordionItem" 
                  aria-expanded="false"
                >
                  <h3 class="accordion-item_heading">
                    <button data-js-target="accordionItem.toggle" aria-expanded="false">
                      <span class="label"><?= $title ?></span>
                      <?= get_icon('chevron-down') ?>
                    </button>
                  </h3> 
                  <section class="accordion-item_content" data-js-target="accordionItem.content">
                    <div class="copy">
                      <div class="copy--body">
                        <div class="wysiwyg"><?= $content ?></div>
                      </div>
                    </div>
                  </section>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>

        </div>
      </div>
    </section>
  <?php return ob_get_clean();
}
