<?php

/**
 * Site info
 */

function get_site_info(string $key = null): mixed {
  static $config = null;

  if ($config === null) {
    $config = [
      'name' => get_theme_option('brand_name') ?: get_bloginfo('name'),
      'description' => get_theme_option('brand', 'description') ?: get_bloginfo('description'),
      'email' => get_theme_option('contact', 'email') ?: get_option('admin_email'),
      'social_links' => [],
      'keys' => [
        'google_maps' => 'AIzaSyCyy_b8XakzJZ2Ad-u2OyfA4CqXh7VWWC4',
      ],
    ];

    // Only add GitHub if URL exists
    if ($github_url = get_theme_option('social', 'github_url')) {
      $config['social_links']['github'] = [
        'name' => 'GitHub',
        'text' => sprintf("Go to %s's GitHub repo", get_site_info('name')),
        'href' => $github_url,
        'icon' => 'github',
      ];
    }

    // Only add email if it exists
    if ($email = get_site_info('email')) {
      $config['social_links']['email'] = [
        'name' => 'Email',
        'text' => sprintf('Email %s', get_site_info('name')),
        'href' => sprintf('mailto:%s', $email),
        'icon' => 'envelope',
      ];
    }
  }

  return $key ? $config[$key] ?? null : $config;
}
