</main>
<?php
$app = get_app_data();
$global = $app['global_data'] ?? [];
$footer = $app['footer_data'] ?? [];
function generate_footer_styles($footer) {
  $styles = [];
  $styles = array_filter([
    $footer['space_top'] ?? null,
    $footer['space_bottom'] ?? null,
  ]);

  $classes = [];

  // css variables
  if ($background_color = get_field('footer_opt_background_color', 'options')) {
    $styles[] = '--background-color: ' . esc_attr($background_color);
  }
  if ($text_color = get_field('footer_opt_text_color', 'options')) {
    $styles[] = '--text-color: ' . esc_attr($text_color);
  }
  if ($text_muted_color = get_field('footer_opt_text_muted_color', 'options')) {
    $styles[] = '--text-muted-color: ' . esc_attr($text_muted_color);
  }
  if ($border_color = get_field('footer_opt_border_color', 'options')) {
    $styles[] = '--border-color: ' . esc_attr($border_color);
  }

  // css classes
  if ($theme = get_field('footer_opt_theme', 'options')) {
    $footer = ['theme' => match ($theme ?? null) {
      '0' => null,
      '1' => 'light',
      '2' => 'dark',
      default => null,
    }];

    $classes[] = esc_attr('theme--' . $footer['theme']);
  }
  if ($section_border = get_field('footer_opt_section_border', 'options')) {
    $classes[] = esc_attr('has-border');
  }

  $style_string = !empty($styles) ? 'style="' . implode('; ', $styles) . '"' : '';
  $class_string = !empty($classes) ? implode(' ', $classes) : '';

  return [$style_string, $class_string];
}

[$styles, $additional_classes] = generate_footer_styles($footer);

?>
<?php component('popup')?>
<footer
  class="<?= cn('section section-footer', !empty($footer['variant']) ? 'variant--'.$footer['variant'] : null, !empty($footer['space_top']) ? 'u-space-top' : null,!empty($footer['space_bottom']) ? 'u-space-bottom' : null,$additional_classes) ?>"
  <?= $styles ?>
>
  <?php component('footer/footer' . ($footer['variant'] ? '-variant--' . $footer['variant'] : ''),$global); ?>

</footer>

</div><!-- app -->

<?php wp_footer(); ?>

</body>
</html>
