<?php

function generate_background_styles($data) {
  $styles = [];
  $type = $data['type'];

  if ($type === null || $type === '') {
    return;
  }

  switch ($type) {
    case 1:
      if (!empty($data['solid_color'])) {
        $styles[] = "--background-color: {$data['solid_color']}";
      }
      break;
    case 2:
      if (!empty($data['gradient_top_color']) && !empty($data['gradient_bottom_color'])) {
        $styles[] = "--background-swatch-top: {$data['gradient_top_color']}";
        $styles[] = "--background-swatch-bottom: {$data['gradient_bottom_color']}";
      }
      break;
    case 3:
      if (!empty($data['background_image'])) {
        $styles[] = "--background-img: url(\"{$data['background_image']}\")";
      }
      break;
    default:
      $styles = [];
  }

  if (empty($styles)) {
    return null;
  }

  return implode('; ', $styles) . ';';
}

/**
 * Functions used to build style arrays
 */

function build_simple_vars(array $rules, array $fields): array {
  $styles = [];

  foreach ($rules as $rule) {
    $var = $rule['var'] ?? null;
    $field = $rule['field'] ?? null;
    $unit = $rule['unit'] ?? '';

    if (!$var || !$field) {
      continue;
    }

    $val = $fields[$field] ?? null;
    if ($val === null || $val === '') {
      continue;
    }

    $escaped = htmlspecialchars((string) $val, ENT_QUOTES, 'UTF-8');
    $styles[] = "{$var}: {$escaped}{$unit}";
  }

  return $styles;
}

// variables based on background field group. @see lib/acf/schemas/common/background.php
function build_background_vars(array $data): array {
  $styles = [];

  $type = $data['type'] ?? null;
  if ($type === null || $type === '') {
    return [];
  }

  switch ($type) {
    case 1: // solid colour
      if (!empty($data['solid_color'])) {
        $styles[] = '--background-color: ' . htmlspecialchars($data['solid_color'], ENT_QUOTES, 'UTF-8');
      }
      break;

    case 2: // gradient
      if (!empty($data['gradient_top_color']) && !empty($data['gradient_bottom_color'])) {
        $styles[] = '--background-swatch-top: ' . htmlspecialchars($data['gradient_top_color'], ENT_QUOTES, 'UTF-8');
        $styles[] =
          '--background-swatch-bottom: ' . htmlspecialchars($data['gradient_bottom_color'], ENT_QUOTES, 'UTF-8');
      }
      break;

    case 3: // image
      if (!empty($data['background_image'])) {
        $escapedUrl = htmlspecialchars($data['background_image'], ENT_QUOTES, 'UTF-8');
        $styles[] = '--background-img: url("' . $escapedUrl . '")';
      }
      break;
  }

  return $styles;
}

/**
 * Merges passed arrays, turning them in a single valid CSS string
 */
function build_style_string(...$declarations): string {
  $merged = array_merge(...$declarations);

  if (!empty($merged)) {
    return implode('; ', $merged) . ';';
  }

  return '';
}
