<?php

/**
 * Functions and utilities for dealing with dates
 */

function get_localized_date($post_id = null) {
  if (!$post_id) {
    $post_id = get_the_ID();
  }

  // Get current WPML language
  $current_lang = apply_filters('wpml_current_language', null);

  // Get post date timestamp
  $timestamp = get_post_timestamp($post_id);

  switch ($current_lang) {
    case 'fr':
      // French format: 19 mars 2025
      return wp_date('j F Y', $timestamp, wp_timezone());
    case 'en':
    default:
      // English format: March 19, 2025
      return wp_date('F j, Y', $timestamp, wp_timezone());
  }
}
