<?php

/**
 * Functions and utilities for dealing with images
 */

function get_feat_img($post_id = null, $size = 'large', $fallback_url = '') {
  // if no post ID is provided, get the current post ID
  if (!$post_id) {
    $post_id = get_the_ID();
  }

  $default = [
    'url' => $fallback_url,
    'alt' => '',
    'srcset' => '',
    'sizes' => '',
    'width' => '',
    'height' => '',
    'title' => '',
    'caption' => '',
    'full_tag' => '',
    'thumbnail_id' => null,
  ];

  // if post has no thumbnail and no fallback, return default array
  if (!has_post_thumbnail($post_id) && empty($fallback_url)) {
    return $default;
  }

  // get thumbnail ID
  $thumbnail_id = get_post_thumbnail_id($post_id);

  // if no thumbnail and fallback provided, return fallback data
  if (!$thumbnail_id && !empty($fallback_url)) {
    $default['full_tag'] = '<img src="' . esc_url($fallback_url) . '" alt="" />';
    return $default;
  }

  // get image data
  $image = wp_get_attachment_image_src($thumbnail_id, $size);
  $full_tag = wp_get_attachment_image($thumbnail_id, $size, false, ['class' => 'featured-image']);

  return [
    'url' => $image ? $image[0] : $fallback_url,
    'alt' => get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true),
    'srcset' => wp_get_attachment_image_srcset($thumbnail_id, $size),
    'sizes' => wp_get_attachment_image_sizes($thumbnail_id, $size),
    'width' => $image ? $image[1] : '',
    'height' => $image ? $image[2] : '',
    'title' => get_the_title($thumbnail_id),
    'caption' => wp_get_attachment_caption($thumbnail_id),
    'full_tag' => $full_tag,
    'thumbnail_id' => $thumbnail_id,
  ];
}
