<?php

function prefetch_link(string $href, string $label = null, array $args = []) {
  $args = wp_parse_args($args, [
    'class' => '',
    'prefetch' => true,
    'attrs' => [], // any other <a> attributes
  ]);

  $url = esc_url(user_trailingslashit(home_url($href)));
  $text = $label !== null ? wp_kses_post($label) : esc_html($url);
  $class = $args['class'] ? esc_attr($args['class']) : '';
  ?>

  <a
    href="<?= $url ?>"
    class="<?= cn('link', $class) ?>"
    <?= $args['prefetch'] ? 'data-prefetch="true"' : 'data-prefetch="false"' ?>
    <?php foreach ($args['attrs'] as $key => $val): ?>
      <?= esc_attr($key) ?>="<?= esc_attr($val) ?>"
    <?php endforeach; ?>
  >
    <?= $text ?>
  </a>

  <?php
}

add_action(
  'wp_footer',
  function () {
    ?>
  <script>
  (function(){
    const prefetched = new Set();
    document.addEventListener('mouseover', e => {
      const a = e.target.closest('a[data-prefetch="true"]');
      if(!a) return;
      const url = a.href;
      if(!url || prefetched.has(url)) return;
      const link = document.createElement('link');
      link.rel  = 'prefetch';
      link.href = url;
      link.crossOrigin = 'anonymous';
      document.head.appendChild(link);
      prefetched.add(url);
    });
  })();
  </script>
  <?php
  },
  999
);
