<?php

function build_nav_tree($elements, $parentId = 0) {
  if (!is_array($elements) && !is_object($elements)) {
    return [];
  }

  $branch = [];
  foreach ($elements as $element) {
    if ($element->menu_item_parent == $parentId) {
      $description = get_field('menu_item_description', $element);

      $element->description = $description ?: '';

      $children = build_nav_tree($elements, $element->ID);
      if ($children) {
        $element->children = $children;
      }
      $branch[$element->ID] = $element;
      unset($element);
    }
  }
  return $branch;
}

function get_menu($location, $args = []) {
  $locations = get_nav_menu_locations();
  if (!isset($locations[$location]) || !$locations[$location]) {
    return [];
  }

  $object = wp_get_nav_menu_object($locations[$location]);
  if (!$object) {
    return [];
  }

  $menu_items = wp_get_nav_menu_items($object->name, $args);
  if (empty($menu_items)) {
    return [];
  }

  return build_nav_tree($menu_items);
}
