<?php

namespace PlexibleTheme\Setup;

/**
 * Theme setup
 */
function setup() {
  // register menu locations
  // https://developer.wordpress.org/reference/functions/register_nav_menus/
  register_nav_menus([
    'header_menu_main' => __('Header Main', 'plexible-theme'),
    'header_menu_cta' => __('Header CTA', 'plexible-theme'),
    'footer_group_1' => __('Footer Group 1', 'plexible-theme'),
    'footer_group_2' => __('Footer Group 2', 'plexible-theme'),
    'footer_group_3' => __('Footer Group 3', 'plexible-theme'),
  ]);

  // enable features
  add_theme_support('automatic-feed-links');
  add_theme_support('title-tag');
  add_theme_support('post-thumbnails');
  add_theme_support('editor-styles');

  // use main stylesheet for visual editor
  add_editor_style('dist/css/style.css');
}
add_action('after_setup_theme', __NAMESPACE__ . '\\setup');

/**
 * Theme assets
 */
function assets() {
  $envPath = get_theme_file_path('.env');
  if (file_exists($envPath)) {
    $env = parse_ini_file($envPath);
    if (!defined('VITE_DEV_URL')) {
      define('VITE_DEV_URL', $env['VITE_DEV_URL'] ?? '');
    }
  } else {
    if (!defined('VITE_DEV_URL')) {
      define('VITE_DEV_URL', '');
    }
  }

  function is_vite_dev_mode(): bool {
    return defined('VITE_DEV_URL') && !empty(VITE_DEV_URL);
  }

  // misc assets
  wp_enqueue_style('dashicons');

  // vite assets
  if (is_vite_dev_mode()) {
    wp_enqueue_script('vite-client', VITE_DEV_URL . '/@vite/client', [], null);
    add_filter(
      'script_loader_tag',
      function ($tag, $handle) {
        if ('vite-client' === $handle) {
          return '<script type="module" src="' . esc_url(VITE_DEV_URL . '/@vite/client') . '"></script>';
        }
        return $tag;
      },
      10,
      2,
    );
    wp_enqueue_script_module('theme-script', VITE_DEV_URL . '/scripts/app.js', [], null, ['in_footer' => true]);
  } else {
    $manifest_path = get_theme_file_path('dist/.vite/manifest.json');
    if (!file_exists($manifest_path)) {
      return;
    }
    $manifest = json_decode(file_get_contents($manifest_path), true);
    if (!empty($manifest['scripts/app.js']['css'])) {
      foreach ($manifest['scripts/app.js']['css'] as $css_file) {
        wp_enqueue_style('theme-style', get_theme_file_uri('dist/' . $css_file));
      }
    }
    if (!empty($manifest['scripts/app.js']['file'])) {
      $js_file = $manifest['scripts/app.js']['file'];
      wp_enqueue_script_module('theme-script', get_theme_file_uri('dist/' . $js_file), [], null, [
        'in_footer' => true,
      ]);
    }
  }
}
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\\assets', 100);

/**
 * Theme cleanup
 */
function remove_support() {
  remove_theme_support('editor-color-palette');
  remove_theme_support('editor-gradient-presets');
  remove_theme_support('editor-font-sizes');
  remove_theme_support('custom-spacing');
  remove_theme_support('wp-block-styles');
}
add_action('after_setup_theme', __NAMESPACE__ . '\\remove_support');

function remove_styles() {
  wp_dequeue_style('global-styles');
  wp_dequeue_style('wp-block-library');
  wp_dequeue_style('wp-block-library-theme');
  wp_dequeue_style('classic-theme-styles');
}
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\\remove_styles', 20);

function disable_jq() {
  if (!is_admin()) {
    wp_dequeue_script('jquery-migrate');
    wp_deregister_script('jquery-migrate');
    wp_dequeue_script('jquery');
    wp_deregister_script('jquery');
  }
}
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\\disable_jq');

// remove WP adminbar in frontend
add_filter('show_admin_bar', '__return_false');

/*
 * Modify TinyMCE editor to remove H1
 */
function modified_tiny_mce($init) {
  // block format elements you want to show in dropdown
  $init['block_formats'] =
    'Paragraph=p;Heading 2=h2;Heading 3=h3;Heading 4=h4;Heading 5=h5;Heading 6=h6;Address=address;Pre=pre;Blockquote=blockquote;';

  $content_css = get_stylesheet_directory_uri() . '/admin/admin.css';
  if (!empty($init['content_css'])) {
    $init['content_css'] .= ',' . $content_css;
  } else {
    $init['content_css'] = $content_css;
  }

  return $init;
}
add_filter('tiny_mce_before_init', __NAMESPACE__ . '\\modified_tiny_mce');
