<?php

add_filter('timber/twig', function ($twig) {
  $twig->addFunction(
    new \Twig\TwigFunction('component', function ($path, $params = []) {
      component($path, $params);
    }),
  );

  $twig->addFunction(
    new \Twig\TwigFunction(
      'html_attrs',
      function (array $attrs): string {
        $out = '';
        foreach ($attrs as $key => $val) {
          // skip null, empty string, and false
          if ($val === null || $val === '' || $val === false) {
            continue;
          }

          $k = htmlspecialchars((string) $key, ENT_QUOTES, 'UTF-8');

          // boolean true: render attribute alone
          if ($val === true) {
            $out .= " {$k}";
            continue;
          }

          // all other values: render key="value"
          $v = htmlspecialchars((string) $val, ENT_QUOTES, 'UTF-8');
          $out .= " {$k}=\"{$v}\"";
        }
        return $out;
      },
      ['is_safe' => ['html']],
    ),
  );

  $twig->addFunction(
    new \Twig\TwigFunction(
      'css_vars',
      function (array $rules, array $fields): ?string {
        $decls = [];

        foreach ($rules as $rule) {
          $var = $rule['var'] ?? null;
          $fld = $rule['field'] ?? null;
          $unit = $rule['unit'] ?? '';

          if (!$var || !$fld) {
            continue;
          }

          $val = $fields[$fld] ?? null;
          if ($val === null || $val === '') {
            continue;
          }

          $escapedVal = htmlspecialchars((string) $val, ENT_QUOTES, 'UTF-8');
          $decls[] = "{$var}: {$escapedVal}{$unit}";
        }

        if (empty($decls)) {
          return null;
        }

        return implode('; ', $decls) . ';';
      },
      ['is_safe' => ['html']],
    ),
  );

  $twig->addFunction(new \Twig\TwigFunction('get_icon', 'get_icon', ['is_safe' => ['html']]));

  $twig->addFunction(new \Twig\TwigFunction('get_acf_icon', 'get_acf_icon', ['is_safe' => ['html']]));

  $twig->addFunction(new \Twig\TwigFunction('get_figure', 'get_figure', ['is_safe' => ['html']]));
  $twig->addFunction(new \Twig\TwigFunction('get_figure_element', 'get_figure_element', ['is_safe' => ['html']]));

  $twig->addFunction(new \Twig\TwigFunction('build_simple_vars', 'build_simple_vars', ['is_safe' => ['html']]));

  $twig->addFunction(new \Twig\TwigFunction('build_background_vars', 'build_background_vars', ['is_safe' => ['html']]));

  // $twig->addFunction(new \Twig\TwigFunction('build_style_string', 'build_style_string', ['is_safe' => ['html']]));

  $maps = [
    'theme_map' => [
      0 => null,
      1 => 'light',
      2 => 'dark',
      3 => 'system',
    ],
    'align_map' => [
      0 => 'start',
      1 => 'center',
      2 => 'end',
    ],
    'distribute_map' => [
      0 => 'start',
      1 => 'center',
      2 => 'end',
      3 => 'space-between',
      4 => 'space-around',
      5 => 'space-evenly',
    ],
    'background_map' => [
      0 => null,
      1 => 'solid',
      2 => 'gradient',
      3 => 'image',
    ],
  ];

  foreach ($maps as $name => $values) {
    $twig->addGlobal($name, $values);
  }

  $twig->addExtension(new \Twig\Extra\Html\HtmlExtension());

  return $twig;
});
