<?php
/**
 * Recursively merges two arrays, replacing values from the first with the second.
 *
 * @param array $defaults
 * @param array $args
 * @return array
 */
function array_merge_deep(array $defaults, array $args) {
  $merged = $defaults;
  foreach ($args as $key => $value) {
    if (is_array($value) && isset($merged[$key]) && is_array($merged[$key])) {
      $merged[$key] = array_merge_deep($merged[$key], $value);
    } else {
      $merged[$key] = $value;
    }
  }
  return $merged;
}

/**
 * Outputs an HTML attribute if the value is not empty
 *
 * @param array $name
 * @param array $value
 * @return string
 */
function attr_if($name, $value): string {
  return !empty($value) ? sprintf(' %s="%s"', $name, esc_attr($value)) : '';
}

/**
 * Converts a string into a URL-friendly slug.
 *
 * @param string $text
 * @param string $divider
 * @return string
 */
function string_to_slug(string $text, string $divider = '-'): string {
  // replace non-letter or digits by divider
  $text = preg_replace('/[^\p{L}\p{Nd}]+/u', $divider, $text);

  // transliterate to ASCII (e.g. “é” → “e”) if possible
  if (function_exists('iconv')) {
    $text = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $text);
  }

  // remove unwanted characters
  $text = preg_replace('/[^A-Za-z0-9' . preg_quote($divider, '/') . ']+/', '', $text);

  // trim dividers from ends
  $text = trim($text, $divider);

  // remove duplicate dividers
  $text = preg_replace('/' . preg_quote($divider, '/') . '{2,}/', $divider, $text);

  // lowercase
  $text = mb_strtolower($text, 'UTF-8');

  return $text === '' ? 'n-a' : $text;
}
