<?php

/**
 * Header
 *
 * Serves as main document header
 */

$app = get_app_data();
$header = $app['header_data'] ?? [];
$banner = $header['banner'];
$default_theme = !empty($app['global_data']['default_theme']) ?'theme--'.$app['global_data']['default_theme']:'theme--light';
$styles = [];
$styles = array_filter([
  $header['space_top'] ?? null,
  $header['space_bottom'] ?? null,
  $header['text_color'] ?? null,
  $header['background_color'] ?? null,
]);
$style_string = !empty($styles) ? 'style="' . implode('; ', $styles) . '"' : '';
$id_string = !empty($header['block_id']) ? 'id="' . $header['block_id'] . '"' : '';
?>

<!doctype html>
<!-- 🛠️ Built with Plexible • https://www.plexible.com/ -->
<html <?php language_attributes(); ?>>

  <head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
  </head>

  <body>

  <?php wp_body_open(); ?>

    <div class="site-transition" data-site-transition></div>

    <div id="app" class="<?= cn($default_theme, 'legacy-ui') ?>">

      <?php if (!empty($banner) && $banner['enabled']): ?>
        <div
          class="<?= cn('announcement-banner') ?>"
          data-js-controller="announcementBanner"
        >
          <div class="announcement-banner-layout">
            <?php component('banner/banner' . ($banner['variant'] ? '-variant--' . $banner['variant'] : '')); ?>

            <button class="announcement-banner-dismiss">
              <?= get_icon('x-mark') ?>
            </button>
          </div>
        </div>
      <?php endif; ?>

      <header
        <?= $id_string ?>
        class="<?= cn('header', !empty($header['sticky']) ? 'is--sticky' : null, !empty($header['variant']) ? 'variant--'.$header['variant'] : null, !empty($header['is_transparent']) ? 'is--transparent' : null, !empty($header['space_top']) ? 'u-space-top' : null,!empty($header['space_bottom']) ? 'u-space-bottom' : null, !empty($header['border']) ? $header['border']: null) ?>"
        data-js-controller="header"
        data-scrolled="false"
        <?= $style_string ?>
        <?= attr_if('data-theme', $header['theme']) ?>
      >
        <?php component('header/header' . ($header['variant'] ? '-variant--' . $header['variant'] : '')); ?>
      </header>

      <main>
