<?php

function get_site_options(): array {
  $options = [];
  $fields = ['brand_name', 'modules'];

  foreach ($fields as $field) {
    $options[$field] = get_field($field, 'option');
  }

  return $options;
}

function get_theme_option($field = null, $subfield = null) {
  if (!function_exists('get_field') || !$field) {
    return false;
  }

  $option = get_field($field, 'option') ?? null;
  if ($subfield) {
    $option = $option[$subfield] ?? null;
  }
  return $option;
}

function update_theme_option($field, $value) {
  if (!function_exists('update_field') || !$field) {
    return false;
  }

  $option = update_field($field, $value, 'option');
  return $option;
}
