<?php

/**
 * Get Background Group
 */

function get_background_fields(string $key = ''): array {
  return [
    [
      'key' => "field_background_type_{$key}",
      'label' => 'Type',
      'name' => 'type',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => [
        0 => 'None',
        1 => 'Solid',
        2 => 'Gradient',
        3 => 'Image',
      ],
      'default_value' => 0,
    ],

    // solid
    [
      'key' => "field_background_color_{$key}",
      'label' => 'Colour',
      'name' => 'solid_color',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
      'conditional_logic' => [
        [
          [
            'field' => "field_background_type_{$key}",
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
    ],

    // gradient
    [
      'key' => "field_background_gradient_top_{$key}",
      'label' => 'Stop top',
      'name' => 'gradient_top_color',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
      'conditional_logic' => [
        [
          [
            'field' => "field_background_type_{$key}",
            'operator' => '==',
            'value' => '2',
          ],
        ],
      ],
    ],
    [
      'key' => "field_background_gradient_bottom_{$key}",
      'label' => 'Stop bottom',
      'name' => 'gradient_bottom_color',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'string',
      'conditional_logic' => [
        [
          [
            'field' => "field_background_type_{$key}",
            'operator' => '==',
            'value' => '2',
          ],
        ],
      ],
    ],

    // image
    [
      'key' => "field_background_image_{$key}",
      'label' => 'Image',
      'name' => 'background_image',
      'type' => 'image',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'return_format' => 'url',
      'mime_types' => ACF_CONSTANTS['ACCEPTED_IMAGE_FILETYPES'],
      'conditional_logic' => [
        [
          [
            'field' => "field_background_type_{$key}",
            'operator' => '==',
            'value' => '3',
          ],
        ],
      ],
    ],
    [
      'key' => "field_background_image_overlay_{$key}",
      'label' => 'Apply Overlay',
      'name' => 'overlay',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
      'conditional_logic' => [
        [
          [
            'field' => "field_background_type_{$key}",
            'operator' => '==',
            'value' => '3',
          ],
        ],
      ],
    ],
  ];
}
