<?php

/**
 * Get Custom Post Terms
 *
 * @param string $key Unique key for field repetition
 * @return array
 */

function get_cpt_fields(string $key = '', array $include = [], string $parent_repeater = ''): array {
  $fields = [
    [
      'key' => "field_cpt_warning_{$key}",
      'label' => 'CAUTION',
      'type' => 'message',
      'message' => ACF_INSTRUCTIONS['CPT_WARNING'],
      'esc_html' => 1,
      'wrapper' => ['class' => 'warning'],
    ],
    [
      'key' => "field_cpt_title_{$key}",
      'label' => 'Title',
      'name' => 'title',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    ],
    [
      'key' => "field_cpt_slug_{$key}",
      'label' => 'Slug',
      'name' => 'slug',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => ACF_INSTRUCTIONS['CPT_SLUG'],
      'maxlength' => ACF_CONSTANTS['CPT_SLUG_MAX_LENGTH'],
    ],
  ];

  return $fields;
}
