<?php

function get_option_fields(
  string $key = '',
  array $extraFields = [],
  string $context = 'default', // default | header | footer,
   array $config = []
): array {

  /**
   * ---------------------------------------------------------
   * Field name prefixing based on context
   * ---------------------------------------------------------
   */

  $prefix = match ($context) {
    'header' => 'header_',
    'footer' => 'footer_',
    'popup' => 'popup_',
    default  => '',
  };

  $field = fn (string $name): string => $prefix . $name;

  /**
   * ---------------------------------------------------------
   * Conditional logic by context
   * ---------------------------------------------------------
   */
  $background_condition = match ($context) {
    'header' => [
      [
        [ 'field' => 'field_var_type_block_header', 'operator' => '!=', 'value' => '0' ],
        [ 'field' => 'field_var_type_block_header', 'operator' => '!=', 'value' => '1' ],
      ],
    ],
    'footer' => [
      [
        [ 'field' => 'field_var_type_partial_footer', 'operator' => '!=', 'value' => '0' ],
        [ 'field' => 'field_var_type_partial_footer', 'operator' => '!=', 'value' => '1' ],
      ],
    ],
    default => [],
  };

  if (
    ($config['disable_background_on_aside'] ?? false) === true
  ) {
    $background_condition[] = [
      [
        'field' => "field_var_type_{$key}",
        'operator' => '!=',
        'value' => '1',
      ],
    ];
  }

  $colors_override_condition = match ($context) {
    'footer' => [
      [ 'field' => 'field_var_type_partial_footer', 'operator' => '!=', 'value' => '0' ],
      [ 'field' => 'field_var_type_partial_footer', 'operator' => '!=', 'value' => '1' ],
    ],
    default => [],
  };

  /**
   * ---------------------------------------------------------
   * Fields definition
   * ---------------------------------------------------------
   */
  return [

    /*
    |--------------------------------------------------------------------------
    | Anchor
    |--------------------------------------------------------------------------
    */
    [
      'key' => "field_opt_anchor_{$key}",
      'label' => 'Anchor ID',
      'name' => $field('opt_anchor'),
      'type' => 'text',
      'instructions' =>
        'Enter an ID using letters, digits, hyphens or underscores (Ex: "my-section", "another_page", or "page-1"). Note: IDs cannot start with a digit',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'maxlength' => 75,
      'prepend' => '#',
    ],

    /*
    |--------------------------------------------------------------------------
    | Appearance
    |--------------------------------------------------------------------------
    */
    [
      'key' => "field_acc_appearance_start_{$key}",
      'label' => 'Appearance',
      'type' => 'accordion',
    ],

    [
      'key' => "field_opt_theme_{$key}",
      'label' => 'Theme',
      'name' => $field('opt_theme'),
      'type' => 'select',
      'choices' => [
        0 => 'Inherit',
        1 => 'Light',
        2 => 'Dark',
        3 => 'System (Coming Soon)',
      ],
      'default_value' => 0,
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'allow_in_bindings' => 1,
    ],

    [
      'key' => "field_opt_text_color_{$key}",
      'label' => 'Text Colour Override',
      'name' => $field('opt_text_color'),
      'type' => 'color_picker',
      'wrapper' => ['width' => '50'],
      'conditional_logic' => $colors_override_condition,
    ],

    [
      'key' => "field_opt_background_color_{$key}",
      'label' => 'Background Colour Override',
      'name' => $field('opt_background_color'),
      'type' => 'color_picker',
      'wrapper' => ['width' => '50'],
      'conditional_logic' => $colors_override_condition,
    ],

    [
      'key' => "field_opt_border_{$key}",
      'label' => 'Border',
      'name' => $field('opt_border'),
      'type' => 'true_false',
      'ui' => 1,
      'conditional_logic' => $colors_override_condition,
    ],

    ...$extraFields,

    [
      'key' => "field_acc_appearance_end_{$key}",
      'label' => 'Appearance',
      'type' => 'accordion',
      'endpoint' => 1,
    ],

    /*
    |--------------------------------------------------------------------------
    | Spacing
    |--------------------------------------------------------------------------
    */
    [
      'key' => "field_acc_spacing_start_{$key}",
      'label' => 'Spacing',
      'type' => 'accordion',
    ],

    [
      'key' => "field_opt_space_top_{$key}",
      'label' => 'Spacing Top',
      'name' => $field('opt_space_top'),
      'type' => 'select',
      'wrapper' => ['width' => '50'],
      'choices' => [
        0  => 'None',
        2  => 'Extra Small',
        4  => 'Small',
        5  => 'Regular',
        7  => 'Medium',
        10 => 'Large',
        15 => 'Extra Large',
      ],
      'allow_null' => 1,
      'return_format' => 'value',
    ],

    [
      'key' => "field_opt_space_bottom_{$key}",
      'label' => 'Spacing Bottom',
      'name' => $field('opt_space_bottom'),
      'type' => 'select',
      'wrapper' => ['width' => '50'],
      'choices' => [
        0  => 'None',
        2  => 'Extra Small',
        4  => 'Small',
        5  => 'Regular',
        7  => 'Medium',
        10 => 'Large',
        15 => 'Extra Large',
      ],
      'allow_null' => 1,
      'return_format' => 'value',
    ],

    [
      'key' => "field_acc_spacing_end_{$key}",
      'label' => 'Spacing',
      'type' => 'accordion',
      'endpoint' => 1,
    ],

    /*
    |--------------------------------------------------------------------------
    | Background Image
    |--------------------------------------------------------------------------
    */
    [
      'key' => "field_acc_background_start_{$key}",
      'label' => 'Background Image',
      'type' => 'accordion',
      'conditional_logic' => $background_condition,
    ],

    [
      'key' => "field_opt_background_image_{$key}",
      'label' => 'Background Image',
      'name' => $field('opt_background_image'),
      'type' => 'image',
      'return_format' => 'url',
      'mime_types' => ACF_CONSTANTS['ACCEPTED_IMAGE_FILETYPES'],
      'wrapper' => ['width' => '50'],
      'conditional_logic' => $background_condition,
    ],

    [
      'key' => "field_opt_background_overlay_{$key}",
      'label' => 'Background Overlay',
      'name' => $field('opt_background_overlay'),
      'type' => 'true_false',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
      'conditional_logic' => $background_condition,
    ],

    [
      'key' => "field_acc_background_end_{$key}",
      'label' => 'Background Image',
      'type' => 'accordion',
      'endpoint' => 1,
      'conditional_logic' => $background_condition,
    ],
  ];
}
