<?php

function acf_tab(string $uid, array $config): array {
  if (empty($config['label'])) {
    throw new InvalidArgumentException('acf_tab requires a "label"');
  }
  $label = $config['label'];
  $defaults = [
    'key' => "field_tab_{$label}_{$uid}",
    'label' => $label,
    'type' => 'tab',
  ];
  return array_merge($defaults, $config);
}

function acf_accordion(string $uid, array $config): array {
  if (empty($config['label'])) {
    throw new InvalidArgumentException('acf_accordion requires a "label"');
  }

  $label = $config['label'];
  $is_end = !empty($config['endpoint']);
  $suffix = $is_end ? 'end' : 'start';
  $defaults = [
    'key' => "field_acc_{$label}_{$suffix}_{$uid}",
    'label' => $label,
    'type' => 'accordion',
  ];

  if ($is_end) {
    $defaults['endpoint'] = 1;
  } else {
    $defaults += [
      'open' => $config['open'] ?? 0,
      'multi_expand' => $config['multi_expand'] ?? 0,
    ];
  }

  return array_merge($defaults, $config);
}

function acf_group(string $uid, array $config): array {
  if (empty($config['name'])) {
    throw new InvalidArgumentException('acf_group requires a "name"');
  }
  $name = $config['name'];
  $label = $config['label'] ?? ucwords(str_replace('_', ' ', $name));

  $defaults = [
    'key' => "field_{$name}_{$uid}",
    'name' => $name,
    'label' => $label,
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'sub_fields' => [],
  ];

  return array_merge($defaults, $config);
}

function acf_repeater(string $uid, array $config): array {
  if (empty($config['name'])) {
    throw new InvalidArgumentException('acf_repeater requires a "name"');
  }
  $name = $config['name'];
  $label = $config['label'] ?? ucwords(str_replace('_', ' ', $name));

  $defaults = [
    'key' => "field_{$name}_{$uid}",
    'name' => $name,
    'label' => $label,
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'layout' => 'table',
    'min' => 0,
    'max' => 0,
    'button_label' => 'Add Row',
    'sub_fields' => [],
  ];

  return array_merge($defaults, $config);
}

function acf_wysiwyg(string $uid, array $config): array {
  if (empty($config['name'])) {
    throw new InvalidArgumentException('acf_wysiwyg requires a "name"');
  }
  $name = $config['name'];
  $label = $config['label'] ?? ucwords(str_replace('_', ' ', $name));
  $defaults = [
    'key' => "field_{$name}_{$uid}",
    'name' => $name,
    'label' => $label,
    'type' => 'wysiwyg',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'toolbar' => 'full',
    'media_upload' => 1,
  ];
  return array_merge($defaults, $config);
}

function acf_select(string $uid, array $config): array {
  if (empty($config['name']) || empty($config['choices']) || !is_array($config['choices'])) {
    throw new InvalidArgumentException('acf_select requires "name" and array "choices"');
  }
  $name = $config['name'];
  $choices = $config['choices'];
  $label = $config['label'] ?? ucwords(str_replace('_', ' ', $name));
  $defaults = [
    'key' => "field_{$name}_{$uid}",
    'name' => $name,
    'label' => $label,
    'type' => 'select',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => $choices,
    'default_value' => $config['default_value'] ?? array_key_first($choices),
  ];
  return array_merge($defaults, $config);
}

function acf_gallery(string $uid, array $config): array {
  if (empty($config['name'])) {
    throw new InvalidArgumentException('acf_gallery requires a "name"');
  }
  $name = $config['name'];
  $label = $config['label'] ?? ucwords(str_replace('_', ' ', $name));

  $defaults = [
    'key' => "field_{$name}_{$uid}",
    'name' => $name,
    'label' => $label,
    'type' => 'gallery',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'min' => 0,
    'max' => 0,
    'insert' => 'append',
    'return_format' => 'array',
  ];

  return array_merge($defaults, $config);
}
