<?php

$block = BLOCK_INDEX['1'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_group($uid, [
    'name' => 'hero',
    'sub_fields' => [
      // Hero → Content
      acf_group($uid, [
        'name' => 'content',
        'label' => 'Content',
        'wrapper' => ['width' => '60'],
        'sub_fields' => get_copy_fields($uid),
      ]),

      // Hero → Figure Repeater
      acf_repeater($uid, [
        'name' => 'figure',
        'label' => 'Figure',
        'layout' => 'block',
        'min' => 1,
        'max' => 6,
        'button_label' => 'Add Figure',
        'wrapper' => ['width' => '40'],
        'sub_fields' => get_figure_fields($uid, [], "field_hero_figure_{$uid}"),
        'conditional_logic' => [
          [
            [
              'field' => "field_var_type_{$uid}",
              'operator' => '!=',
              'value' => '3',
            ],
          ],
        ],
      ]),

      // Hero → Gallery
      acf_gallery($uid, [
        'name' => 'gallery',
        'label' => 'Gallery',
        'min' => 9,
        'max' => 12,
        'wrapper' => ['width' => '40'],
        'conditional_logic' => [
          [
            [
              'field' => "field_var_type_{$uid}",
              'operator' => '==',
              'value' => '3',
            ],
          ],
        ],
      ]),
    ],
  ]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default', 1 => 'Split', 2 => 'Lower Third', 3 => 'Parallax Grid', 4 => 'Blox'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
