<?php

$block = BLOCK_INDEX['6'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_form_id_{$uid}",
    'label' => 'Form ID',
    'name' => 'form_id',
    'type' => 'number',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'instructions' => 'ID of the Formidable form to include. (Formidable > Forms)',
    'required' => 1,
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default', 1 => 'Contact Info', 2 => 'Card'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
